/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.config.SingleCategoryTag;

public class CategoryDescription
implements Serializable {
    private static final Logger LOG = Logger.getLogger(CategoryDescription.class.getName());
    private final String categoryName;
    private final List<SingleCategoryTag> singleTags = new ArrayList<SingleCategoryTag>();
    volatile boolean hasChanges = false;
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "defaultInitial";
    public static final String DEFAULT_CAT = "";
    public static final String DEFAULT_V_STRING = "d";
    private static final String LATEST_V_STRING = "l";
    private static final String UNDEF_V_STRING = "u";
    public static final int DEFAULT_VERSION = -1;
    public static final int LATEST_VERSION = -2;
    public static final int UNDEF_VERSION = -3;
    private static final Pattern CATEGORY_TAG_PATTERN = Pattern.compile("((?<category>.*?)[:])?(?<tags>.*?)(?<hasChanged>\\*?)");
    private static final Pattern TAG_PATTERN = Pattern.compile("([{]{1}(?<source>.*?)[}]{1})?(?<tag>.*?)([(]{1}?((?<version>[a-zA-Z0-9]*))[)]{1})?");

    public CategoryDescription(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    @Deprecated
    public boolean containsSingleTag(String tag, String source) {
        return this.containsSingleTag(new SingleCategoryTag(source, tag, this.categoryName));
    }

    public boolean containsSingleTag(SingleCategoryTag singleCategoryTag) {
        return this.singleTags.contains(singleCategoryTag);
    }

    public String getSingleTagVersion(SingleCategoryTag singleCategoryTag) {
        if (!this.singleTags.contains(singleCategoryTag)) {
            throw new IllegalArgumentException("Sourced tag \"" + singleCategoryTag + "\" does not exist for this CategoryTag");
        }
        return this.singleTags.get(this.singleTags.indexOf(singleCategoryTag)).getVersion();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCategoryName()).append(":");
        int nTags = this.getNumberOfTags();
        for (SingleCategoryTag sourcedTag : this.getSingleCategoryTags()) {
            sb.append(sourcedTag.toStringNoCategory());
            if (--nTags <= 0) continue;
            sb.append("|");
        }
        if (this.hasChanges) {
            sb.append("*");
        }
        return sb.toString();
    }

    public void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public List<SingleCategoryTag> getSingleCategoryTags() {
        return new ArrayList<SingleCategoryTag>(this.singleTags);
    }

    public void addOrUpdadateSingleTagVersion(String source, String tag, String version) {
        SingleCategoryTag singleTag = new SingleCategoryTag(source, tag, this.categoryName, version);
        this.addSingleTagVersion(singleTag, version, true);
    }

    public void addOrUpdadateSingleTag(SingleCategoryTag singleCategoryTag) {
        SingleCategoryTag singleTag = new SingleCategoryTag(singleCategoryTag);
        this.addSingleTagVersion(singleTag, singleTag.getVersion(), true);
    }

    public void addSingleTagVersion(SingleCategoryTag singleTag, String version, boolean update) {
        if (this.singleTags.contains(singleTag) && !update) {
            throw new RuntimeException("Tag: " + singleTag.getTag() + " for source: " + singleTag.getSource() + " already exists for this CategoryTag");
        }
        SingleCategoryTag newTag = new SingleCategoryTag(singleTag, version);
        int ind = this.singleTags.indexOf(newTag);
        if (ind < 0) {
            this.singleTags.add(newTag);
        } else {
            this.singleTags.remove(ind);
            this.singleTags.add(ind, newTag);
        }
    }

    int getNumberOfTags() {
        return this.singleTags.size();
    }

    public CategoryDescription merge(CategoryDescription categoryTag) {
        for (SingleCategoryTag singleTag : categoryTag.getSingleCategoryTags()) {
            this.addSingleTagVersion(singleTag, singleTag.getVersion(), true);
        }
        return this;
    }

    @Deprecated
    public static final CategoryDescription parseCategoryTagInput(String categoryTagInput) {
        return CategoryDescription.parseCategoryTagInput(categoryTagInput, "");
    }

    public static final CategoryDescription parseCategoryTagInput(String categoryTagInput, String defaultSource) {
        Matcher m = CATEGORY_TAG_PATTERN.matcher(categoryTagInput);
        if (m.matches()) {
            String[] stringArray;
            String cat = m.group("category");
            if (cat == null) {
                cat = "";
            }
            CategoryDescription categoryTag = new CategoryDescription(cat);
            String allTags = m.group("tags");
            if (allTags == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = allTags.split("\\|");
            }
            String[] tags = stringArray;
            boolean hasChanged = "*".equals(m.group("hasChanged"));
            categoryTag.setHasChanges(hasChanged);
            for (String t : tags) {
                String ver;
                String source;
                String tag;
                Matcher tagMatcher = TAG_PATTERN.matcher(t);
                if (tagMatcher.matches()) {
                    String v;
                    tag = tagMatcher.group("tag");
                    if (tag == null) {
                        tag = "";
                    }
                    if ((source = tagMatcher.group("source")) == null || source.isEmpty()) {
                        source = defaultSource;
                    }
                    ver = v = tagMatcher.group("version");
                    if (v == null || v.isEmpty() || v.equals(DEFAULT_V_STRING)) {
                        ver = DEFAULT_V_STRING;
                    }
                } else {
                    throw new IllegalArgumentException("Could not match tag: " + t);
                }
                categoryTag.addSingleTagVersion(new SingleCategoryTag(source, tag, cat), ver, false);
            }
            return categoryTag;
        }
        throw new IllegalArgumentException("Could not parse a CategoryTag from input string: \"" + categoryTagInput + "\"");
    }
}

