package org.lsst.ccs.config;

/**
 * A class describing a single category tag.
 * A single category tag is described by:
 *  - the source of the data
 *  - the category of the configuration parameters it describes
 *  - the tag
 *  - the version
 * 
 * A SingleCategoryTag is expressed as: category:{source}tag(version)
 * 
 * 
 * @author The LSST CCS Team
 */
public class SingleCategoryTag {
    
    private final String category, source, tag, version;
    public final static String DEFAULT_VERSION = "d";
    
    public SingleCategoryTag(String source, String tag, String category) {
        this(source, tag, category, DEFAULT_VERSION);
    }
    
    public SingleCategoryTag(String source, String tag, String category, String version) {
        this.category = category;
        this.source = source;
        this.tag = tag;
        this.version = version;
//        if (source == null || source.isEmpty()) {
//            throw new RuntimeException("Cannot build a SingleCategory object with a null or empty source!!");
//        }
        if ( category == null ) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null category!!");
        }
        if ( tag == null ) {
            throw new RuntimeException("Cannot build a SingleCategory object with a null tag!!");
        }
    }

    //Copy constructor
    public SingleCategoryTag(SingleCategoryTag t) {
        this(t, t.version);
    }
    
    //Copy constructor with updated version
    public SingleCategoryTag(SingleCategoryTag t, String version) {
        this(t.source, t.tag, t.category, version);
    }
    
    public String getCategory() {
        return category;
    }

    public String getSource() {
        return source;
    }

    public String getTag() {
        return tag;
    }

    public String getVersion() {
        return version;
    }

    @Override
    public String toString() {
        return category+":"+toStringNoCategory();
    }

    public String toStringNoCategory() {
        String sourceStr = (source != null && ! source.isEmpty()) ? "{"+source+"}" : "";
        return sourceStr+tag+"("+version+")";
    }

    @Override
    public boolean equals(Object obj) {
        if ( obj instanceof SingleCategoryTag ) {
            SingleCategoryTag t = (SingleCategoryTag)obj;
            if ( t.tag.equals(tag) && t.category.equals(category) ) {
                if ( source == null ) {
                    return t.source == null;
                }
                return source.equals(t.source);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return tag.hashCode() + (source != null ? 23*source.hashCode() : 0 ) + 154 * category.hashCode();
    }
}
