package org.lsst.ccs.bus.data;

import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 * An enumeration to distinguish between a NORMAL and SIMULATED subsystem.
 * 
 * @author The LSST CCS Team
 */

public enum RunMode {
    NORMAL, SIMULATION;

    public static final String AGENT_RUNMODE_PROPERTY="runMode";
    public static final String RUNMODE_SYSTEM_PROPERTY="org.lsst.ccs.run.mode";

    public static RunMode getRunMode() {
        if ( isSimulation() ) {
            return SIMULATION;
        }
        return NORMAL;
    }
    
    public static boolean isSimulation() {
        return BootstrapResourceUtils.getBootstrapSystemProperties().getProperty(RUNMODE_SYSTEM_PROPERTY, "normal").equals(SIMULATION.name().toLowerCase());
    }
}
