package org.lsst.ccs.bus.states;

/**
 * The Alert State of an Agent reflects how the hardware measured quantities
 * compare to their operational limits.
 * The Alert State is, at any point, the level of the highest active existing alarm.
 * 
 * It is also used to represent the severity of an Alert. 
 * It can be either WARNING or ALARM, depending on the condition in which the 
 * Alert is raised. When an Alert is raised the severity determines the change 
 * in the agent AlertState. The agent AlertState will match
 * the highest severity level and lock onto it until all Alerts at that level
 * have been cleared.
 * 
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * @author The LSST CCS Team
 */

public enum AlertState implements AgentState {

    /**
     * The NOMINAL AlertState signifies that a given quantity has gone back
     * within acceptable limits. Alerts are not raised when the AlertState
     * is NOMINAL. There is no effect on the AlertState of the agent.
     * 
     */
    NOMINAL,

    /**
     * The WARNING AlertState signifies that a given quantity has reached
     * the warning level. The corresponding Alert is raised and the AlertState
     * of the Agent will switch to WARNING if it was previously NOMINAL, 
     * otherwise the AlertState of the agent will remain unchanged.
     * 
     */
    WARNING,
    
    /**
     * The ALARM AlertState signifies that a given quantity has reached
     * the alarm level. The corresponding Alert is raised and the AlertState
     * of the agent will switch to ALARM if it was previously either NOMINAL or 
     * WARNING, otherwise the AlertState of the agent will remain unchanged.
     * 
     */
    ALARM;    
}
