package org.lsst.ccs.bus.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 * Infrastructure level Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum InfrastructureAlert {

    
    
    /**
     * Alert raised when a periodic task falls behind.
     */
    PERIODIC_TASK_BEHIND("PeriodicTaskBehind","Alert raised when a periodic task falls behind."),
    /**
     * Alert raised when the ASPICs temperature is too hot.
     */
    PERIODIC_TASK_FAILURE("PeriodicTaskFailure","Alert raised when periodic tasks have failures (exceptions) during execution. At ALARM level the task execution is terminated."),
    /**
     * Alert raised when the ASPICs temperature is too hot.
     */
    STATE_MISMATCH("StateMismatch","Alert raised the internal state is inconsistent with the actual state");
    
    
    private final String id, description;
    
    InfrastructureAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id,description);
    }
    
}
