package org.lsst.ccs.bus.messages;


import org.lsst.ccs.bus.states.StateBundle;

/**
 * A StatusChangeNotification for State changes.
 * This is an event driven message sent on the Status bus when a State change
 * occurs. It contains the new (current) state of the subsystem and the old one.
 * 
 * @author The LSST CCS Team
 */
public final class StatusStateChangeNotification extends StatusMessage<StateBundle,Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 7295728245721L;
    
    /**
     * Create a StatusStateChangeNotification object.
     * 
     * @param oldState The old state before the State change
     */
    public StatusStateChangeNotification(StateBundle oldState) {
        super(oldState);
    }


    /**
     * Get the new state of the Agent.
     * @return The new state of the Agent.
     */
    public StateBundle getNewState() {
        return getState();
    }

    /**
     * Get the old state of the Agent.
     * @return The old state of the Agent.
     */
    public StateBundle getOldState() {
        return getObject();
    }
    
    @Override
    protected Object encodeObject(StateBundle obj) {
        return null;
    }
    
}
