package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;


/**
 * Base class for all status messages containing an RaisedAlert.
 * A RaisedAlert object is embedded within this StatusRaisedAlert.
 * StatusRaisedAlert provides no encoding as the RaisedAlert object already encodes
 * the original Alerts that triggered the publication.
 * 
 * @author LSST CCS Team
 * 
 */
public final class StatusRaisedAlert extends StatusAlert<Alert, Alert> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 4320480793736L;
    
    private final String cause;
   
     /**
     * Build a StatusAlert from the provided RaisedAlert.
     *
     * @param alert The RaisedAlert object that caused the publication of this StatusAlert.
     * @param cause What caused the Alert to be raised.
     * @param raisedAlertSummary the summary of all uncleared alerts at the time
     * the object is created.
     */
    public StatusRaisedAlert(Alert alert, String cause, RaisedAlertSummary raisedAlertSummary) {
        super(alert, raisedAlertSummary);
        this.cause = cause;
    }

    /**
     * Get the RaisedAlert contained in this message.
     * @return The RaisedAlert.
     * @throws EmbeddedObjectDeserializationException if the embedded object
     * cannot be de-serialized
     */
    public Alert getRaisedAlert() {
        return getObject();
    }
    
    @Override
    protected Alert encodeObject(Alert obj) {
        return new Alert(obj.getAlertId(),obj.getDescription());
    }
    
    /**
     * Get the String explaining what caused the Alert.
     * @return the cause of the Alert.
     */
    public String getCause() {
        return cause;
    }
    

}
