package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import org.lsst.ccs.bus.data.RaisedAlertSummary;

/**
 * Base class for Alert raising and clearing status.
 * It provides a {@code RaisedAlertSummary}
 * 
 * @param <T>
 * @param <D> 
 * @author The LSST CCS Team
 */
public abstract class StatusAlert<T extends Serializable, D> extends StatusMessage<T, D> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 432047923342L;
    
    private final RaisedAlertSummary raisedAlertSummary;

    StatusAlert( T obj, RaisedAlertSummary raisedAlertSummary) {
        super(obj);
        this.raisedAlertSummary = raisedAlertSummary;
    }

    /**
     * 
     * @return the alert summary for the origin subsystem
     */
    public RaisedAlertSummary getRaisedAlertSummary(){
        return raisedAlertSummary;
    }
    
}
