package org.lsst.ccs.bus.data;

import java.io.Serializable;

/**
 *
 * @author LSST CCS Team
 */
public interface AgentLock extends Serializable {

    /**
     * The agent name this lock stands for.
     * @return the agent name this lock stands for.
     */
    public String getAgentName();

    /**
     * The agent that own this lock.
     * @return the name of the agent that owns this lock
     */
    public String getOwnerAgentName();

    /**
     * The maximum level allowed by this lock.
     * @return  the maximum level allowed by this lock
     */
    public int getMaxLevel();

    /**
     * The lock owner's userID.
     * @return
     */
    public String getUserID();

    /**
     * The user or agent that owns the lock
     * @return the owner name for this lock
     */
    public default String getOwnerName() {
        return getUserID() == null ? getOwnerAgentName() : getUserID();
    };
}
