package org.lsst.ccs.bus.data;

/**
 * An enumeration that represent the type of a ConfigurationParameter.
 * 
 * @author The LSST CCS Team
 */
public enum ConfigurationParameterType {
    
    //A ConfigurationParameter that can be changed anytime during the
    //lifetime of a CCS Agent
    RUNTIME,
    //A Configuration Parameter used during the HasLifecycle::build step.
    //This parameter can only be modified either in the groovy file or
    //when loading the safe properties
    BUILD,
    //A Configuration Parameter that can only be changed during initialization
    //and then never modified. This is meant to be used for parameters like
    //ip addresses, connection types etc.
    FINAL,
    //A read-only Configuration Parameter. This type of parameter is monitored
    //by the Configuration Service but it cannot be changed via the commands
    //provided by the Configuration Service.
    READ_ONLY;
   
    
}
