package org.lsst.ccs.bus.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Predicate;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;

/**
 * A Predicate used to select agents based on the provided properties.
 * This class can be used as a configuration.
 * 
 * An example of how this class can be created from a string:
 * 
 * [agentCategory:FOCAL_PLANE,group:ENVIRONMENT,agentName:a1,agentType:WORKER]
 * 
 * @author The LSST CCS Team
 */
public class AgentPropertyPredicate implements Predicate<AgentInfo> {

    private final Map<String, String> properties;

    public AgentPropertyPredicate(String propertiesStr) {
        this(propertiesStr, new HashMap());
    }
    public AgentPropertyPredicate(String propertiesStr, Map<String,String> replacements) {
        //Brute force replacement. If needed a better implementation
        //will be provided.
        for (Entry<String,String> e : replacements.entrySet()) {
            String wild = "${"+e.getKey()+"}";
            propertiesStr = propertiesStr.replace(wild,e.getValue());
        }
        properties = (Map) InputConversionEngine.convertArgToType(propertiesStr, Map.class);
    }

    public AgentPropertyPredicate(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean test(AgentInfo agent) {
        for (Map.Entry<String, String> e : properties.entrySet()) {
            String property = e.getKey();
            String propertyValue = e.getValue();
            if ((propertyValue != null && !propertyValue.isEmpty()) && !propertyValue.equals(agent.getAgentProperty(property))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return TypeUtils.stringify(properties);
    }

}
