package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Properties;

/**
 * A Class to capture the information regarding this distribution.
 *
 * @author The LSST CCS Team
 *
 */
public final class DistributionInfo implements Serializable {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 3563213329104789L;

    private final String project;
    private final String version;
    private final String buildNumber;
    private final String buildId;
    private final String buildUrl;
    private final String buildJdk;
    private final String sourceCodeUrl;
    private final String sourceCodeRevision;

    public DistributionInfo() {
        this(System.getProperties());
    }
    
    public DistributionInfo(Properties props) {
        project = props.getProperty("org.lsst.ccs.project", "");
        version = props.getProperty("org.lsst.ccs.project.version", "");
        buildNumber = props.getProperty("org.lsst.ccs.jenkins.build.number", "");
        buildId = props.getProperty("org.lsst.ccs.jenkins.build.id", "");
        buildUrl = props.getProperty("org.lsst.ccs.jenkins.build.url", "");
        buildJdk = props.getProperty("org.lsst.ccs.jenkins.build.jdk", "");
        sourceCodeUrl = props.getProperty("org.lsst.ccs.source.code.url", "");
        sourceCodeRevision = props.getProperty("org.lsst.ccs.source.code.revision", "");
    }
    
    public String getProject() {
        return project;
    }

    public String getVersion() {
        return version;
    }

    public String getBuildNumber() {
        return buildNumber;
    }

    public String getBuildId() {
        return buildId;
    }

    public String getBuildUrl() {
        return buildUrl;
    }

    public String getBuildJdk() {
        return buildJdk;
    }

    public String getSourceCodeUrl() {
        return sourceCodeUrl;
    }

    public String getSourceCodeRevision() {
        return sourceCodeRevision;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tProject        : ").append(project).append("\n");
        sb.append("\tProject Version: ").append(version).append("\n");
        sb.append("\tBuild Number   : ").append(buildNumber).append("\n");
        sb.append("\tBuild Id       : ").append(buildId).append("\n");
        sb.append("\tBuild Url      : ").append(buildUrl).append("\n");
        sb.append("\tBuild Jdk      : ").append(buildJdk).append("\n");
        sb.append("\tSource Code Rev: ").append(sourceCodeRevision).append("\n");
        sb.append("\tSource Code Url: ").append(sourceCodeUrl).append("\n");
        return sb.toString();        
    }
    
}
