/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationInfoTest {
    @Test
    public void test1() {
        ConfigurationInfo ci = new ConfigurationInfo.Builder().setConfigurationState(ConfigurationState.CONFIGURED).setDescription("descriptionName").build();
        Assert.assertEquals((Object)"descriptionName[]", (Object)ci.getConfigurationName());
        Assert.assertEquals((Object)"descriptionName", (Object)ci.getDescriptionName());
        ci = new ConfigurationInfo.Builder().setConfigurationState(ConfigurationState.DIRTY).setDescription("descriptionName").updateCategoryInformation("volt", "hi", Integer.valueOf(-3), false).updateCategoryInformation("", "normal", Integer.valueOf(-3), true).build();
        Assert.assertEquals((Object)"descriptionName[normal*,volt:hi]", (Object)ci.getConfigurationName());
        Assert.assertEquals((Object)"descriptionName", (Object)ci.getDescriptionName());
        Assert.assertTrue((boolean)ci.hasChanges());
        Assert.assertTrue((boolean)ci.hasCategory("volt"));
        Assert.assertEquals((Object)"hi", (Object)ci.getConfigNameForCategory("volt"));
        Assert.assertEquals((Object)"normal", (Object)ci.getConfigNameForCategory(""));
        ci = new ConfigurationInfo.Builder().setConfigurationState(ConfigurationState.DIRTY).setDescription("descriptionName").updateCategoryInformation("volt", "hi", Integer.valueOf(3), false).updateCategoryInformation("", "normal", Integer.valueOf(4), true).setGlobalConfigurationInformation("aGlobalName", Integer.valueOf(17)).addParameter(ParameterPath.valueOf((String)"someComp/parm1"), Integer.class, "", "", false, false).updateParameter(ParameterPath.valueOf((String)"someComp/parm1"), "1", "11", true).addParameter(ParameterPath.valueOf((String)"someComp/parm2"), String.class, "A", "", false, false).updateParameter(ParameterPath.valueOf((String)"someComp/parm2"), "2", "22", true).addParameter(ParameterPath.valueOf((String)"someComp/parm3"), String.class, "B", "", false, false).updateParameter(ParameterPath.valueOf((String)"someComp/parm3"), "3", "33", true).addParameter(ParameterPath.valueOf((String)"otherComp/parm1"), Double.class, "", "", false, false).updateParameter(ParameterPath.valueOf((String)"otherComp/parm1"), "1", "11", true).addParameter(ParameterPath.valueOf((String)"otherComp/parm2"), String.class, "A", "", false, false).updateParameter(ParameterPath.valueOf((String)"otherComp/parm2"), "2", "22", true).addParameter(ParameterPath.valueOf((String)"otherComp/parm3"), String.class, "B", "", false, false).updateParameter(ParameterPath.valueOf((String)"otherComp/parm3"), "3", "33", true).addRecentChange("someComp/parm1").addRecentChange("someComp/parm2").build();
        Assert.assertEquals((Object)"descriptionName[aGlobalName(17)][normal(4)*,volt:hi(3)]", (Object)ci.getConfigurationName());
        Map res = ConfigurationInfo.getParameterInfoGroupByCategory((List)ci.getAllParameterInfo());
        Assert.assertEquals((long)2L, (long)((List)res.get("")).size());
        Assert.assertEquals((long)2L, (long)((List)res.get("A")).size());
        Assert.assertEquals((long)2L, (long)((List)res.get("B")).size());
        res = ConfigurationInfo.getParameterInfoGroupByComponent((List)ci.getAllParameterInfo());
        Assert.assertEquals((long)3L, (long)((List)res.get("someComp")).size());
        Assert.assertEquals((long)3L, (long)((List)res.get("otherComp")).size());
        Map currVals = ci.getCurrentValuesFor("someComp");
        Assert.assertEquals((String)"someComp size", (long)3L, (long)currVals.size());
        Assert.assertEquals((Object)"11", currVals.get("parm1"));
        Assert.assertEquals((Object)"22", currVals.get("parm2"));
        Assert.assertEquals((Object)"33", currVals.get("parm3"));
        currVals = ci.getCurrentValuesForCategory("A");
        Assert.assertEquals((String)"category A size", (long)2L, (long)currVals.size());
        Assert.assertEquals((Object)"22", currVals.get("someComp/parm2"));
        Assert.assertEquals((Object)"22", currVals.get("otherComp/parm2"));
    }
}

