package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * A dictionary of published data.
 * @author LSST CCS Team
 */
public interface DataProviderDictionary extends Serializable {
    
    /**
     * @return the existing list of DataProviders
     */
    public List<DataProviderInfo> getDataProviderInfos();

    /**
     * @return the existing groups
     */
    public Set<String> getGroups();

    /**
     * @param group
     * @return 
     */
    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group);
    
    /**
     * Get the CCSTimeStamp of when this dictionary was created.
     * 
     * @return The CCSTimeStamp when this dictionary was created.
     */
    public CCSTimeStamp getCCSTimeStamp();
   
}