package org.lsst.ccs.bus.data;

import java.util.Objects;
import java.io.Serializable;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class AgentLockInfo implements AgentLock, Serializable {

    private static final long serialVersionUID = 4416294268287507663L;
    private final String agentName;
    private final String ownerAgent;
    private final String userId;
    private final int maxLevel;
    private final CCSTimeStamp timeStamp;

    public enum Status {
        REQUESTED, ACKNOWLEDGED, RELEASED, REJECTED, LEVEL_UPDATE
    }

    private final Status status;

    public AgentLockInfo(String agentName, String ownerAgent) {
        this.agentName = agentName;
        this.userId = "";
        this.maxLevel = Command.NOT_DEFINED;
        this.status = Status.REQUESTED;
        this.timeStamp = CCSTimeStamp.currentTime();
        this.ownerAgent = ownerAgent;
    }

    public AgentLockInfo(String agentName, String ownerAgent, String userId, int maxLevel, Status status,
            CCSTimeStamp timeStamp) {
        super();
        this.agentName = agentName;
        this.ownerAgent = ownerAgent;
        this.userId = userId;
        this.maxLevel = maxLevel;
        this.status = status;
        this.timeStamp = timeStamp;
    }

    public AgentLockInfo(AgentLockInfo lock, Status status, CCSTimeStamp timeStamp) {
        this.agentName = lock.agentName;
        this.userId = lock.userId;
        this.maxLevel = lock.maxLevel;
        this.status = status;
        this.timeStamp = timeStamp;
        this.ownerAgent = lock.ownerAgent;
    }

    @Override
    public String getAgentName() {
        return agentName;
    }

    @Override
    public String getOwnerAgentName() {
        return ownerAgent;
    }

    @Override
    public String getUserID() {
        return userId;
    }

    @Override
    public int getMaxLevel() {
        return maxLevel;
    }

    public Status getStatus() {
        return status;
    }

    public CCSTimeStamp getTimeStamp() {
        return timeStamp;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.agentName);
        hash = 67 * hash + Objects.hashCode(this.userId);
        hash = 67 * hash + this.maxLevel;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final AgentLockInfo other = (AgentLockInfo) obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.userId, other.userId)) {
            return false;
        }
        if (this.maxLevel != other.maxLevel) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "Lock " + agentName + " by " + getOwnerAgentName() + " " + status + " at " + timeStamp.getUTCInstant().toString();
    }

}
