package org.lsst.ccs.bus.messages;

import java.util.HashMap;
import org.lsst.ccs.command.Dictionary;


/**
 * StatusMessage dedicated to command dictionary publication.
 * It contains a map of all the targets/dictionaries for a given agent.
 * 
 * This object is published by the {@code AgentCommandDictionaryService}; consoles
 * should listen to the STATUS bus for these publications.
 * 
 * @author LSST CCS Team
 * 
 */
public final class StatusCommandDictionary extends StatusMessage<HashMap<String, Dictionary>,Object>  {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -69280792879L;
    
   
    public StatusCommandDictionary(HashMap<String, Dictionary> dictionary) {
        super(dictionary);
    }


    /**
     * Get the actual dictionary contained in this StatusMessage.
     * @return The Map of targets/dictionaries.
     */
    public HashMap<String, Dictionary> getDictionary() {
        return getObject();
    }
    
    
    @Override
    protected Object encodeObject(HashMap<String, Dictionary> dictionary) {
        return null;
    }

    
    

}
