/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class RaisedAlertInstance
implements Serializable {
    private static final long serialVersionUID = 312950371630569273L;
    private final AlertState severity;
    private final long timestamp;
    private CCSTimeStamp ccsTimeStamp;
    private final String description;
    private final int count;

    @Deprecated
    RaisedAlertInstance(AlertState severity, long timestamp, String cause) {
        this(severity, timestamp, cause, 1);
    }

    RaisedAlertInstance(AlertState severity, CCSTimeStamp ccsTimeStamp, String cause) {
        this(severity, ccsTimeStamp, cause, 1);
    }

    @Deprecated
    RaisedAlertInstance(AlertState severity, long timestamp, String cause, int count) {
        this.severity = severity;
        this.timestamp = timestamp;
        this.description = cause;
        this.count = count;
        this.ccsTimeStamp = CCSTimeStamp.currentTimeFromMillis((long)timestamp);
    }

    RaisedAlertInstance(AlertState severity, CCSTimeStamp ccsTimeStamp, String cause, int count) {
        this.severity = severity;
        this.timestamp = ccsTimeStamp.getUTCInstant().toEpochMilli();
        this.description = cause;
        this.count = count;
        this.ccsTimeStamp = ccsTimeStamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public AlertState getAlertState() {
        return this.severity;
    }

    public String getCause() {
        return this.description;
    }

    public int getCount() {
        return this.count;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ccsTimeStamp == null) {
            this.ccsTimeStamp = CCSTimeStamp.currentTimeFromMillis((long)this.timestamp);
        }
    }
}

