package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;

/**
 ****************************************************
 *
 *  Contains the state of a monitor-only subsystem
 *
 *  @author Owen Saxton
 *
 ****************************************************
 */
public class MonMainState implements Serializable 
{
    
    public static final String KEY = "MonMainState";

    private final int tickMillis;         // Data status update period (ms)
 
    public MonMainState(int tickMillis)
    {
        this.tickMillis = tickMillis;
    }
    
    public int getTickMillis()
    {
        return tickMillis;
    }

    @Override
    public String toString()
    {
        return "tickMillis=" + tickMillis;
    }

    private static final long serialVersionUID = -4921460960657878432L;
}
