/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder;

public class TestStateBundle {
    private static final String CLASS_ROOT = "org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder$";

    @Test
    public void testBundleCreation() {
        StateBundle bundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING});
        bundle.setComponentState("someComponent", new Enum[]{ComponentState.STATE1});
        bundle.setComponentState("someComponent", new Enum[]{ComponentAdditionalState.ONE});
        bundle.setComponentState("someOtherComponent", new Enum[]{ComponentState.STATE2});
        bundle.setComponentState("unknownComponent", new Enum[]{ComponentState.UNKNOWN});
        Assert.assertTrue((boolean)bundle.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)bundle.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((boolean)bundle.isComponentInState("someComponent", (Enum)ComponentState.STATE1));
        Assert.assertTrue((boolean)bundle.isComponentInState("someOtherComponent", (Enum)ComponentState.STATE2));
        Assert.assertTrue((boolean)bundle.isComponentInState("unknownComponent", (Enum)ComponentState.UNKNOWN));
        Assert.assertTrue((!bundle.isInState((Enum)CommandState.READY) ? 1 : 0) != 0);
        Assert.assertTrue((!bundle.isComponentInState("unknownComponent", (Enum)ComponentAdditionalState.ONE) ? 1 : 0) != 0);
        Assert.assertTrue((!bundle.isComponentInState("wrongComponent", (Enum)ComponentState.UNKNOWN) ? 1 : 0) != 0);
        StateBundle bundle2 = new StateBundle(new Enum[0]);
        bundle2.setComponentState("someComponent", new Enum[]{ComponentState.STATE1});
        bundle2.setComponentState("someOtherComponent", new Enum[]{ComponentState.STATE2});
        bundle2.setComponentState("unknownComponent", new Enum[]{ComponentState.UNKNOWN});
        Assert.assertTrue((boolean)bundle.isInState(bundle2));
        StateBundle componentStateBundle = new StateBundle(new Enum[0]);
        bundle.setState(new Enum[]{ComponentState.STATE1});
        bundle.setState(new Enum[]{ComponentAdditionalState.ONE});
        Assert.assertTrue((boolean)bundle.isComponentInState("someComponent", componentStateBundle));
    }

    @Test
    public void testBundleMerge() {
        StateBundle bundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING});
        bundle.setComponentState("someComponent", new Enum[]{ComponentState.STATE1});
        bundle.setComponentState("someComponent", new Enum[]{ComponentAdditionalState.ONE});
        bundle.setComponentState("someOtherComponent", new Enum[]{ComponentState.STATE2});
        bundle.setComponentState("unknownComponent", new Enum[]{ComponentState.UNKNOWN});
        StateBundle bundle2 = new StateBundle(new Enum[]{OperationalState.NORMAL, CommandState.READY});
        bundle2.setComponentState("someComponent", new Enum[]{AnotherAdditionalState.A});
        bundle2.setComponentState("someOtherComponent", new Enum[]{ComponentAdditionalState.THREE});
        StateBundle merge = bundle.mergeState(bundle2);
        merge.setState(new Enum[]{AlertState.NOMINAL});
        Assert.assertTrue((boolean)bundle.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)bundle.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((!bundle.isInState((Enum)CommandState.READY) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)merge.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)merge.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((boolean)merge.isInState((Enum)CommandState.READY));
        Assert.assertTrue((boolean)merge.isInState((Enum)AlertState.NOMINAL));
        Assert.assertTrue((boolean)merge.isComponentInState("someComponent", (Enum)ComponentState.STATE1));
        Assert.assertTrue((boolean)merge.isComponentInState("someComponent", (Enum)ComponentAdditionalState.ONE));
        Assert.assertTrue((boolean)merge.isComponentInState("someComponent", (Enum)AnotherAdditionalState.A));
        Assert.assertEquals((Object)((Object)ComponentState.STATE2), (Object)merge.getComponentState("someOtherComponent", ComponentState.class));
        Assert.assertTrue((boolean)merge.isComponentInState("someOtherComponent", (Enum)ComponentAdditionalState.THREE));
        Assert.assertTrue((boolean)merge.isComponentInState("unknownComponent", (Enum)ComponentState.UNKNOWN));
        Assert.assertNotEquals((Object)((Object)ComponentAdditionalState.TWO), (Object)merge.getComponentState("unknownComponent", ComponentAdditionalState.class));
    }

    @Test
    public void testBundleDiff() throws Exception {
        StateBundle oldbundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING, AlertState.WARNING});
        oldbundle.setComponentState("someComponent", new Enum[]{ComponentState.STATE1});
        oldbundle.setComponentState("someComponent", new Enum[]{ComponentAdditionalState.ONE});
        oldbundle.setComponentState("someOtherComponent", new Enum[]{ComponentState.STATE2});
        oldbundle.setComponentState("unknownComponent", new Enum[]{ComponentState.UNKNOWN});
        StateBundle newbundle = new StateBundle(new Enum[]{OperationalState.NORMAL, CommandState.READY, AlertState.WARNING});
        newbundle.setComponentState("someComponent", new Enum[]{ComponentState.STATE2});
        newbundle.setComponentState("someComponent", new Enum[]{ComponentAdditionalState.TWO});
        newbundle.setComponentState("someOtherComponent", new Enum[]{ComponentState.UNKNOWN});
        newbundle.setComponentState("unknownComponent", new Enum[]{ComponentAdditionalState.THREE});
        newbundle.setComponentState("unknownComponent", new Enum[]{ComponentState.STATE1});
        StateBundle oldBundleAfter = this.deserialize(this.serialize(oldbundle));
        StateBundle newBundleAfter = this.deserialize(this.serialize(newbundle));
        Assert.assertEquals((Object)oldbundle, (Object)oldBundleAfter);
        Assert.assertEquals((Object)newbundle, (Object)newBundleAfter);
        StateBundle diffState = newBundleAfter.diffState(oldBundleAfter);
        Assert.assertEquals((Object)OperationalState.NORMAL, (Object)diffState.getState(OperationalState.class));
        Assert.assertEquals((Object)CommandState.READY, (Object)diffState.getState(CommandState.class));
        Assert.assertEquals((Object)((Object)ComponentState.STATE2), (Object)diffState.getComponentState("someComponent", ComponentState.class));
        Assert.assertEquals((Object)((Object)ComponentAdditionalState.THREE), (Object)diffState.getComponentState("unknownComponent", ComponentAdditionalState.class));
        Assert.assertNull((Object)diffState.getState(AlertState.class));
        Assert.assertNull((Object)diffState.getState(PhaseState.class));
        StateBundle finalbundle = new StateBundle(new Enum[]{OperationalState.NORMAL, CommandState.READY});
        newbundle.setComponentState("someComponent", new Enum[]{ComponentState.STATE2});
        newbundle.setComponentState("someComponent", new Enum[]{ComponentAdditionalState.TWO});
        newbundle.setComponentState("someOtherComponent", new Enum[]{ComponentState.UNKNOWN});
        newbundle.setComponentState("unknownComponent", new Enum[]{ComponentAdditionalState.THREE});
        newbundle.setComponentState("unknownComponent", new Enum[]{ComponentState.STATE1});
        Assert.assertTrue((boolean)diffState.isInState(finalbundle));
    }

    @Test
    public void testStateBundleCustomSerialization() throws Exception {
        StateBundle before = new StateBundle(new Enum[]{OperationalState.NORMAL, PhaseState.CLOSING});
        before.setComponentState("someComponent", new Enum[]{ComponentState.STATE2});
        before.setComponentState("someComponent", new Enum[]{ComponentAdditionalState.TWO});
        before.setComponentState("someOtherComponent", new Enum[]{ComponentState.UNKNOWN});
        before.setComponentState("unknownComponent", new Enum[]{ComponentAdditionalState.THREE});
        before.setComponentState("unknownComponent", new Enum[]{ComponentState.STATE1});
        byte[] ser = this.serialize(before);
        StateBundle after = this.deserialize(ser);
        Assert.assertTrue((boolean)after.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)after.isInState((Enum)PhaseState.CLOSING));
        Assert.assertEquals((Object)before, (Object)after);
        Assert.assertTrue((boolean)after.isInState(before));
        StateBundle componentState = new StateBundle(new Enum[]{ComponentState.STATE2, ComponentAdditionalState.TWO});
        Assert.assertTrue((boolean)after.isComponentInState("someComponent", componentState));
    }

    @Test
    public void testSubsystemSpecifcStateBundleCustomSerialization() throws Exception {
        StateBundle before = new StateBundle(new Enum[]{OperationalState.NORMAL, PhaseState.INITIALIZING, CommandState.READY});
        SubsystemSpecificStateAdder.addFilterState(before, true);
        SubsystemSpecificStateAdder.addShutterState(before, false);
        byte[] ser = this.serialize(before);
        StateBundle after = this.deserialize(ser);
        Assert.assertTrue((boolean)after.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)after.isInState((Enum)PhaseState.INITIALIZING));
        Assert.assertTrue((boolean)after.isInState((Enum)CommandState.READY));
        Assert.assertEquals((long)2L, (long)after.getInternalStates().size());
        Assert.assertEquals((Object)"LOADING", after.getInternalStates().get("org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder$FilterState"));
        Assert.assertEquals((Object)"CLOSED", after.getInternalStates().get("org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder$ShutterState"));
        ser = this.serialize(after);
        StateBundle after2 = this.deserialize(ser);
        Assert.assertEquals((Object)after, (Object)after2);
    }

    @Test
    public void testLegalTransitions() {
        StateBundle before = new StateBundle(new Enum[]{PhaseState.INITIALIZING, OperationalState.ENGINEERING_FAULT, AlertState.ALARM});
        StateBundle after = new StateBundle(new Enum[]{PhaseState.OPERATIONAL, OperationalState.ENGINEERING_FAULT, AlertState.ALARM});
        Assert.assertTrue((boolean)AgentState.isLegal((StateBundle)before, (StateBundle)after));
        before = new StateBundle(new Enum[]{PhaseState.INITIALIZING, OperationalState.ENGINEERING_FAULT, AlertState.ALARM});
        after = new StateBundle(new Enum[]{PhaseState.OPERATIONAL, OperationalState.ENGINEERING_OK, AlertState.ALARM});
        Assert.assertFalse((boolean)AgentState.isLegal((StateBundle)before, (StateBundle)after));
    }

    private byte[] serialize(StateBundle bundle) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(bundle);
        byte[] res = bos.toByteArray();
        bos.close();
        oos.close();
        return res;
    }

    private StateBundle deserialize(byte[] ba) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ba));
        StateBundle sb = (StateBundle)ois.readObject();
        ois.close();
        return sb;
    }

    private static enum AnotherAdditionalState {
        A,
        B,
        C;

    }

    private static enum ComponentAdditionalState {
        ONE,
        TWO,
        THREE;

    }

    private static enum ComponentState {
        UNKNOWN,
        STATE1,
        STATE2;

    }
}

