package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * Base class for Alert raising and clearing status.
 * It provides a {@code RaisedAlertSummary}
 * 
 * @param <T>
 * @param <D> 
 * @author The LSST CCS Team
 */
public abstract class StatusAlert<T extends Serializable, D> extends StatusMessage<T, D> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -99432048079237342L;
    
    private final RaisedAlertSummary raisedAlertSummary;

    StatusAlert( T obj, StateBundle state, RaisedAlertSummary raisedAlertSummary) {
        super(obj, state);
        this.raisedAlertSummary = raisedAlertSummary;
    }

    /**
     * 
     * @return the alert summary for the origin subsystem
     */
    public RaisedAlertSummary getRaisedAlertSummary(){
        return raisedAlertSummary;
    }
    
}
