package org.lsst.ccs.bus.messages;

import java.io.Serializable;

/**
 * Command NACK.
 * Returned when a CommandRequest has been rejected and will not be carried out.
 * 
 * @author emarin
 * @param <T> The template for the embedded object.
 */
public final class CommandNack<T extends Serializable> extends CommandReply<T> {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 334545356909L;
    
    /**
     * CommandNacks are built from the corresponding CommandRequest and the
     * reason for which the command will not be carried out.
     * 
     * @param command The CommandRequest that originated the nack.
     * @param reason The reason the command will not be carried out.
     */
    public CommandNack(CommandRequest command, T reason) {
        super(command, reason);
    }
    
    /**
     * The reason for the refusal.
     * It is the String representation of the provided reason.
     * So this is equivalent to invoking getEncodedData on the BusMessage.
     * 
     * @return The reason for rejecting a CommandRequest.
     */
    public String getReason() {
        return getEncodedData();
    }

            
}
