package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;
import java.util.BitSet;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 ************************************************
 *
 *  Contains the state of the monitoring system.
 *
 *  @author Owen Saxton
 *
 ************************************************
 */
@SkipEncoding
public class MonitorState implements Serializable {

    public static final String KEY = "MonitorState";

    BitSet goodChans,          //  Good channels, in id order
           onlineChans,        //  Online channels. in id order
           lowLimitChange,     //  Channels with low limit changes, in id order
           highLimitChange;    //  Channels with high limit changes, in id order

    public MonitorState(BitSet goodChans, BitSet onlineChans,
                        BitSet lowLimitChange, BitSet highLimitChange)
    {
        this.goodChans       = goodChans;
        this.onlineChans     = onlineChans;
        this.lowLimitChange  = lowLimitChange;
        this.highLimitChange = highLimitChange;
    }
    
    public BitSet getGoodChans()
    {
        return goodChans;
    }

    public BitSet getOnlineChans()
    {
        return onlineChans;
    }

    public BitSet getLowLimitChange()
    {
        return lowLimitChange;
    }

    public BitSet getHighLimitChange()
    {
        return highLimitChange;
    }

    @Override
    public String toString()
    {
        return "goodChans=" + goodChans
                + ", onlineChans=" + onlineChans
                + ", lowLimitChange=" + lowLimitChange
                + ", highLimitChange=" + highLimitChange;
    }

    private static final long serialVersionUID = -4522689157338013037L;
}
