/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class KeyValueDataList
extends KeyValueData
implements Serializable,
Iterable<KeyValueData> {
    private static final long serialVersionUID = 234989123019230913L;

    public KeyValueDataList() {
        this("");
    }

    public KeyValueDataList(String key) {
        this(key, CCSTimeStamp.currentTime());
    }

    @Deprecated
    public KeyValueDataList(String key, long timestamp) {
        super(key, new ArrayList(), CCSTimeStamp.currentTimeFromMillis((long)timestamp));
    }

    public KeyValueDataList(String key, CCSTimeStamp ccsTimeStamp) {
        super(key, new ArrayList(), ccsTimeStamp);
    }

    @Deprecated
    public KeyValueDataList(long timestamp) {
        this("", CCSTimeStamp.currentTimeFromMillis((long)timestamp));
    }

    public KeyValueDataList(CCSTimeStamp ccsTimeStamp) {
        this("", ccsTimeStamp);
    }

    public void addData(String key, Serializable value) {
        if (value instanceof KeyValueDataList || value instanceof KeyValueData) {
            throw new IllegalArgumentException("Data cannot be DataList or KeyValueData");
        }
        this.addData(new KeyValueData(key, value, this.getCCSTimeStamp()));
    }

    public void addData(String key, Serializable value, KeyValueData.KeyValueDataType type) {
        this.addData(key, value, CCSTimeStamp.currentTime(), type);
    }

    @Deprecated
    public void addData(String key, Serializable value, long timestamp) {
        this.addData(key, value, CCSTimeStamp.currentTimeFromMillis((long)timestamp), KeyValueData.KeyValueDataType.KeyValueTrendingData);
    }

    public void addData(String key, Serializable value, CCSTimeStamp ccsTimeStamp) {
        this.addData(key, value, ccsTimeStamp, KeyValueData.KeyValueDataType.KeyValueTrendingData);
    }

    @Deprecated
    public void addData(String key, Serializable value, long timestamp, KeyValueData.KeyValueDataType type) {
        if (value instanceof KeyValueData) {
            throw new IllegalArgumentException("Value cannot be KeyValueData, please use method addData(KeyDataValue).");
        }
        this.addData(new KeyValueData(key, value, timestamp, type));
    }

    public void addData(String key, Serializable value, CCSTimeStamp ccsTimeStamp, KeyValueData.KeyValueDataType type) {
        if (value instanceof KeyValueData) {
            throw new IllegalArgumentException("Value cannot be KeyValueData, please use method addData(KeyDataValue).");
        }
        this.addData(new KeyValueData(key, value, ccsTimeStamp, type));
    }

    public List<KeyValueData> getListOfKeyValueData() {
        return this.getListOfKeyValueData(null);
    }

    public List<KeyValueData> getListOfKeyValueData(KeyValueData.KeyValueDataType type) {
        ArrayList<KeyValueData> list = new ArrayList<KeyValueData>();
        for (KeyValueData d : (List)((Object)this.getValue())) {
            if (type != null && type != d.getType()) continue;
            list.add(d);
        }
        return list;
    }

    public void addData(KeyValueData data) {
        ((ArrayList)this.getValue()).add(data);
    }

    @Override
    public Iterator<KeyValueData> iterator() {
        return this.getListOfKeyValueData().iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (KeyValueData d : this) {
            if (!isFirst) {
                sb.append(", ");
            } else {
                isFirst = false;
            }
            sb.append(d.getKey()).append("=").append(d.getValue());
        }
        return sb.toString();
    }
}

