/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class ConfigurationInfo
implements Serializable {
    private static final long serialVersionUID = 349664303742923784L;
    public static final int DEFAULT_VERSION = -1;
    public static final int LATEST_VERSION = -2;
    public static final int UNDEF_VERSION = -3;
    private String descriptionName;
    private String globalName;
    private Integer version = -3;
    private final Map<String, Boolean> hasCategoryChanged = new HashMap<String, Boolean>();
    private final Map<String, String> tags = new HashMap<String, String>();
    private final Map<String, Integer> versions = new HashMap<String, Integer>();
    private ConfigurationState configState;
    private final List<String> recentChanges = new ArrayList<String>();
    private final List<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();
    private CCSTimeStamp ccsTimeStamp;
    private long time;

    public String getDescriptionName() {
        return this.descriptionName;
    }

    @Deprecated
    public long getTimestamp() {
        return this.time;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public String getConfigurationName() {
        StringBuilder sb = new StringBuilder(this.descriptionName);
        if (this.globalName != null) {
            sb.append("[").append(this.globalName);
            if (this.version != null && this.version != -3) {
                sb.append("(").append(this.version).append(")");
            }
            sb.append("]");
        }
        sb.append("[").append(this.getTaggedCategories()).append("]");
        return sb.toString();
    }

    public String getGlobalName() {
        return this.globalName;
    }

    private String getTaggedCategories() {
        String res = "";
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.tags).entrySet()) {
            boolean hasChanges = this.hasChangesForCategory(entry.getKey());
            Integer v = this.getConfigVersion(entry.getKey());
            res = res + (entry.getKey().isEmpty() ? "" : entry.getKey() + ":") + entry.getValue() + (v < 0 ? "" : "(" + v + ")") + (hasChanges ? "*" : "") + ",";
        }
        if (!res.isEmpty()) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public boolean hasChangesForCategory(String category) {
        return this.hasCategoryChanged.get(category);
    }

    public boolean hasChanges() {
        for (boolean b : this.hasCategoryChanged.values()) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public String getConfigNameForCategory(String category) {
        return this.tags.get(category);
    }

    public Integer getConfigVersion(String cat) {
        if (this.versions == null) {
            return -3;
        }
        Integer ver = this.versions.get(cat);
        return ver == null ? -3 : ver;
    }

    public boolean hasCategory(String category) {
        return this.tags.containsKey(category);
    }

    public Set<String> getCategorySet() {
        return this.tags.keySet();
    }

    public ConfigurationState getConfigurationState() {
        return this.configState;
    }

    public String toString() {
        return "Configuration state : " + this.configState + ":" + this.getConfigurationName();
    }

    public List<ConfigurationParameterInfo> getAllParameterInfo() {
        return Collections.unmodifiableList(this.parametersView);
    }

    public List<ConfigurationParameterInfo> getLatestChanges() {
        return Collections.unmodifiableList(this.parametersView.stream().filter(configParmInfo -> this.recentChanges.contains(configParmInfo.getPathName())).collect(Collectors.toList()));
    }

    public Map<String, String> getCurrentValuesForCategory(String category) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getCategoryName().equals(category)).collect(Collectors.toMap(ConfigurationParameterInfo::getPathName, ConfigurationParameterInfo::getCurrentValue)));
    }

    public Map<String, String> getCurrentValuesFor(String componentName) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getComponentName().equals(componentName)).collect(Collectors.toMap(ConfigurationParameterInfo::getParameterName, ConfigurationParameterInfo::getCurrentValue)));
    }

    public String getCurrentValueForParameter(String pathName) {
        if (pathName.contains("//")) {
            System.out.println("double slash should be removed when accessing the value of a parameter by its path");
        }
        ParameterPath pp = ParameterPath.valueOf((String)pathName);
        return this.parametersView.stream().filter(parmInfo -> parmInfo.getPathName().equals(pp.toString())).map(ConfigurationParameterInfo::getCurrentValue).findFirst().get();
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByComponent(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getComponentName, Collectors.toList()));
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByCategory(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getCategoryName, Collectors.toList()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ccsTimeStamp == null) {
            this.ccsTimeStamp = CCSTimeStamp.currentTimeFromMillis((long)this.time);
        }
    }

    public static class Builder {
        private final ConfigurationInfo ci;
        private final Map<ParameterPath, ConfigurationParameterInfo.Builder> parameterBuilders = new HashMap<ParameterPath, ConfigurationParameterInfo.Builder>();

        public Builder() {
            this.ci = new ConfigurationInfo();
        }

        public Builder setDescription(String description) {
            this.ci.descriptionName = description;
            return this;
        }

        public Builder setGlobalConfigurationInformation(String globalName, Integer version) {
            this.ci.globalName = globalName;
            this.ci.version = version;
            return this;
        }

        public Builder setConfigurationState(ConfigurationState configState) {
            this.ci.configState = configState;
            return this;
        }

        public Builder addParameter(ParameterPath path, Type type, String category, String description, String units, boolean isFinal) {
            ConfigurationParameterInfo.Builder builder = new ConfigurationParameterInfo.Builder();
            builder.addParameter(path, type, category, description, units, isFinal);
            this.parameterBuilders.put(path, builder);
            this.ci.parametersView.add(builder.build());
            return this;
        }

        public Builder updateParameter(ParameterPath path, String configuredValue, String currentValue, boolean dirty) {
            this.parameterBuilders.get(path).updateParameter(configuredValue, currentValue, dirty);
            return this;
        }

        public Builder updateCategoryInformation(String cat, String configName, Integer version, boolean dirty) {
            this.ci.tags.put(cat, configName);
            this.ci.versions.put(cat, version);
            this.ci.hasCategoryChanged.put(cat, dirty);
            return this;
        }

        public Builder addRecentChange(String path) {
            this.ci.recentChanges.add(path);
            return this;
        }

        public Builder updateVersions(int globalVersion, Map<String, Integer> versions) {
            this.ci.versions.putAll(versions);
            this.ci.version = globalVersion;
            return this;
        }

        @Deprecated
        public Builder setTime(long time) {
            this.ci.time = time;
            this.ci.ccsTimeStamp = CCSTimeStamp.currentTimeFromMillis((long)time);
            return this;
        }

        public Builder setCCSTimeStamp(CCSTimeStamp ccsTimeStamp) {
            this.ci.ccsTimeStamp = ccsTimeStamp;
            return this;
        }

        public ConfigurationInfo build() {
            return this.ci;
        }
    }
}

