package org.lsst.ccs.bus.data;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

/**
 * A Class to capture the Health of the running process.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class RuntimeInfo implements Serializable {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -72154637904826248L;
    
    private final int nThreads;
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private final long totalMemory, freeMemory;
    private final double processCpuLoad, systemCpuLoad;
    private transient static final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private transient static final Runtime runtime = Runtime.getRuntime();
    private final int uptime;

    public RuntimeInfo() {
        this(0);
    }
    
    public RuntimeInfo(int uptime) {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();        
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
        this.uptime = uptime;
    }
    

    /**
     * Get the number of threads currently used.
     * @return The number of threads.
     */
    public int getNThreads() {
        return nThreads;
    }

    /**
     * Get the maximum memory allocated for the JVM in bytes
     * @return The maximum memory in bytes
     */
    public long getMaxMemory() {
        return maxMemory;
    }

    /**
     * Get the total memory currently used by the JVM in bytes
     * @return The total memory used in bytes
     */
    public long getTotalMemory() {
        return totalMemory;
    }

    /**
     * Get the JVM free memory in bytes
     * @return The free memory used in bytes
     */
    public long getFreeMemory() {
        return freeMemory;
    }

    /**
     * Get the process current CPU load.
     * @return The current CPU load.
     */
    public double getProcessCpuLoad() {
        return processCpuLoad;
    }

    /**
     * Get the system CPU load.
     * @return The system CPU load.
     */
    public double getSystemCpuLoad() {
        return systemCpuLoad;
    }
    
    /**
     * Get the Agent's uptime in milliseconds.
     * This is the amount of time since the Agent was created.
     * @return The subsystem uptime in milliseconds.
     */
    public int getUptime() {
        return uptime;
    }

}
