package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * A status message containing a RuntimeInfo object.
 * It contains parameters describing the health of the JVM in which the publishing
 * Agent is running.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class StatusRuntimeInfo extends StatusData {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 13329639921L;
    private final RuntimeInfo runtimeInfo;

    /**
     * Create a StatusRuntimeInfo message by providing the state of the agent.
     * Internally a RuntimeInfo object is created.
     * @param state The state of the agent when this object was created.
     * 
     */
    public StatusRuntimeInfo(RuntimeInfo runtimeInfo, StateBundle state){
        super(new KeyValueData("runtimeInfo",runtimeInfo), state);
        this.runtimeInfo = runtimeInfo;
    }
        
    /**
     * Get the RuntimeInfo object contained in this message.
     * @return The RuntimeInfo object embedded in the message.
     */
    public RuntimeInfo getRuntimeInfo() {
        return runtimeInfo;
    }
    
}
