package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.StateBundle;


/**
 * Status message sent when Alerts are cleared.
 * It contains a String array of the alertIds that have been cleared
 * 
 * @author LSST CCS Team
 * 
 */
public final class StatusClearedAlert extends StatusAlert<String[], Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -76938204807923235L;
    
    /**
     * Build a StatusClearAlert from the provided String array and the
     * {@code RaisedAlertSummary} of the subsystem.
     * @param clearAlertIds Array of AlertIds that have been cleared.
     * @param state The State of the Agent at the time the object is created.
     * @param raisedAlertSummary The summary of alerts at the time the object is
     * created.
     */
    public StatusClearedAlert(String[] clearAlertIds, StateBundle state, RaisedAlertSummary raisedAlertSummary) {
        super(clearAlertIds, state, raisedAlertSummary);
    }
    
    /**
     * Get the String array of the alertIds that have been cleared.
     * 
     * @return The String array of with the ids of the alerts that have been cleared.
     */
    public String[] getClearAlertIds() {
        return getObject();
    }
    
    @Override
    protected Object encodeObject(String[] obj) {
        return null;
    }
    
}
