package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.List;

/**
 * 
 * @author LSST CCS Team 
 */
public interface AgentLock extends Serializable {
    
    /**
     * The agent name this lock stands for.
     * @return the agent name this lock stands for.
     */
    public String getAgentName();
    
    /**
     * The agents that own this lock.
     * @return a list of agent names that own this lock
     */
    public List<String> getOwnerAgentNames();

    /** The maximum level allowed by this lock.
     * @return  the maximum level allowed by this lock */
    public int getMaxLevel();
    
    /** The lock owner's userID.
     * @return  */
    public String getUserID();
    
}
