package org.lsst.ccs.bus.data;

import java.io.Serializable;

/**
 * A static description of published data.
 * @author LSST CCS Team
 */
public interface DataProviderInfo extends Serializable {
    
    /**
     * The path of a DataProvider is its location within an Agent.
     * @return  The unique path for this data.
     */
    public String getPath();
    
    /**
     * The key of a DataProvider is used to store the data in the trending database.
     * @return  The key for this data.
     */
    public String getKey();


    /**
     * Get access to the different attributes attached to this data description.
     * @param attr the attr
     * @return 
     */
    public String getAttributeValue(Attribute attr);

    /**
     * Get all the attribute names defined for this data.
     * @return The array of attribute names.
     */
    public Attribute[] getAttributes();
    
    public static enum Attribute {

        DESCRIPTION("description",true),
        UNITS("units",true),
        FORMAT("format",true),
        PAGE("page",false),
        ALARMHI("alarmhi",false),
        ALARMLO("alarmlo",false);

        private final String name;
        private final boolean isMetadata;

        private Attribute(String name, boolean isMetadata) {
            this.name = name;
            this.isMetadata = isMetadata;
        }
        
        public String getName() {
            return name;
        }
        
        public boolean isMetadata() {
            return isMetadata;
        }
    }    
}
