/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DistributionInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.messages.Complex1;
import org.lsst.ccs.bus.messages.Complex2;
import org.lsst.ccs.bus.messages.Complex3;
import org.lsst.ccs.bus.messages.Enum1;
import org.lsst.ccs.bus.messages.SimpleChild;
import org.lsst.ccs.bus.messages.SimpleWithProps;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.messages.WithNullValue;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

public class TestStatusEncoding {
    @BeforeClass
    public static void prepareTest() {
        System.setProperty("org.lsst.ccs.project", "org-lsst-ccs-some-proj");
        System.setProperty("org.lsst.ccs.project.version", "1.8-SNAPSHOT");
        System.setProperty("org.lsst.ccs.jenkins.build.number", "23563");
        System.setProperty("org.lsst.ccs.jenkins.build.id", "adjks-3333 akskll   2");
        System.setProperty("org.lsst.ccs.jenkins.build.url", "http://srs.slac.stanford.edu/hudson?build=222");
        System.setProperty("org.lsst.ccs.jenkins.build.jdk", "1.8.0.34-p");
        System.setProperty("org.lsst.ccs.source.code.url", "svn+ssh://dev.lsstcorp.org/camera/CameraControl/some");
        System.setProperty("org.lsst.ccs.source.code.revision", "3432");
    }

    @AfterClass
    public static void clearTest() {
        System.setProperty("org.lsst.ccs.project.version", "");
        System.setProperty("org.lsst.ccs.jenkins.build.number", "");
        System.setProperty("org.lsst.ccs.jenkins.build.id", "");
        System.setProperty("org.lsst.ccs.jenkins.build.url", "");
        System.setProperty("org.lsst.ccs.jenkins.build.jdk", "");
        System.setProperty("org.lsst.ccs.source.code.url", "");
        System.setProperty("org.lsst.ccs.source.code.revision", "");
    }

    @Test
    public void testSimpleChildEncoding() throws Exception {
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)child), null);
        KeyValueDataList obj1 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("name", (Serializable)((Object)"aSin")));
        toFind.add(new KeyValueData("value", (Serializable)Integer.valueOf(666)));
        toFind.add(new KeyValueData("valDouble", (Serializable)Double.valueOf(0.7)));
        this.testEncodedListsNew(obj1, toFind);
        SimpleChild res = (SimpleChild)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res, (Object)child);
    }

    @Test
    public void testComplex1ObjectEncoding() throws Exception {
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        Complex1 complex1 = new Complex1(child, 966);
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)complex1), null);
        KeyValueDataList obj2 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("son/name", (Serializable)((Object)"aSin")));
        toFind.add(new KeyValueData("son/value", (Serializable)Integer.valueOf(666)));
        toFind.add(new KeyValueData("son/valDouble", (Serializable)Double.valueOf(0.7)));
        toFind.add(new KeyValueData("id", (Serializable)Integer.valueOf(966)));
        this.testEncodedListsNew(obj2, toFind);
        Complex1 res2 = (Complex1)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res2, (Object)complex1);
    }

    @Test
    public void testComplex2ObjectEncoding() throws Exception {
        Complex2 complex2 = new Complex2(new BigDecimal("33.33"), 945);
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)complex2), null);
        KeyValueDataList obj3 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("value", (Serializable)new BigDecimal("33.33")));
        toFind.add(new KeyValueData("id", (Serializable)Integer.valueOf(945)));
        this.testEncodedListsNew(obj3, toFind);
        Complex2 res3 = (Complex2)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res3, (Object)complex2);
    }

    @Test
    public void testEnumerationEncoding() throws Exception {
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)((Object)Enum1.MENEL)), null);
        KeyValueDataList obj4 = e.getEncodedData();
        ArrayList<KeyValueData> list4 = new ArrayList<KeyValueData>();
        for (KeyValueData d : obj4) {
            list4.add(d);
        }
        Assert.assertTrue((list4.size() == 1 ? 1 : 0) != 0);
        KeyValueData d = (KeyValueData)list4.get(0);
        Assert.assertTrue((boolean)d.getKey().equals(""));
        String en = (String)((Object)d.getValue());
        Assert.assertTrue((boolean)en.equals("MENEL"));
        Enum1 res4 = (Enum1)((Object)((KeyValueData)e.getObject()).getValue());
        Assert.assertEquals((Object)((Object)res4), (Object)((Object)Enum1.MENEL));
    }

    @Test
    public void testComplex3ObjectEncoding() throws Exception {
        Complex3 c3 = new Complex3(55, Enum1.MENEL);
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)c3), null);
        KeyValueDataList obj5 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("val", (Serializable)Integer.valueOf(55)));
        toFind.add(new KeyValueData("anEnum", (Serializable)((Object)"MENEL")));
        toFind.add(new KeyValueData("bitset", (Serializable)Long.valueOf(55L)));
        this.testEncodedListsNew(obj5, toFind);
        Complex3 res5 = (Complex3)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res5, (Object)c3);
    }

    @Test
    public void testNullValueEncoding() throws Exception {
        WithNullValue withNullValue = new WithNullValue();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)withNullValue), null);
        KeyValueDataList obj6 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("name", null));
        toFind.add(new KeyValueData("value", (Serializable)Integer.valueOf(0)));
        this.testEncodedListsNew(obj6, toFind);
        WithNullValue res6 = (WithNullValue)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res6, (Object)withNullValue);
    }

    @Test
    public void testConstructorWithPropertiesEncoding() throws Exception {
        SimpleWithProps simpleProps = new SimpleWithProps(3, "abc");
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)simpleProps), null);
        KeyValueDataList obj7 = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("valInt", (Serializable)Integer.valueOf(3)));
        toFind.add(new KeyValueData("valString", (Serializable)((Object)"abc")));
        this.testEncodedListsNew(obj7, toFind);
        SimpleWithProps res7 = (SimpleWithProps)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res7, (Object)simpleProps);
    }

    @Test
    public void testMapEncoding() throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("one", 1);
        map.put("another", new SimpleChild("child", 45, 2345.0));
        map.put("last", "done");
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)map), null);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("one", (Serializable)Integer.valueOf(1)));
        toFind.add(new KeyValueData("another/name", (Serializable)((Object)"child")));
        toFind.add(new KeyValueData("another/value", (Serializable)Integer.valueOf(45)));
        toFind.add(new KeyValueData("another/valDouble", (Serializable)Double.valueOf(2345.0)));
        toFind.add(new KeyValueData("last", (Serializable)((Object)"done")));
        this.testEncodedListsNew(obj, toFind);
        Map res = (Map)((Object)((KeyValueData)e.getObject()).getValue());
        Assert.assertEquals((Object)res, map);
    }

    @Test
    public void testDistributionInfoEncoding() throws Exception {
        DistributionInfo distInfo = new DistributionInfo();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)distInfo), null);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("project", (Serializable)((Object)System.getProperty("org.lsst.ccs.project"))));
        toFind.add(new KeyValueData("version", (Serializable)((Object)System.getProperty("org.lsst.ccs.project.version"))));
        toFind.add(new KeyValueData("buildNumber", (Serializable)((Object)System.getProperty("org.lsst.ccs.jenkins.build.number"))));
        toFind.add(new KeyValueData("buildId", (Serializable)((Object)System.getProperty("org.lsst.ccs.jenkins.build.id"))));
        toFind.add(new KeyValueData("buildUrl", (Serializable)((Object)System.getProperty("org.lsst.ccs.jenkins.build.url"))));
        toFind.add(new KeyValueData("buildJdk", (Serializable)((Object)System.getProperty("org.lsst.ccs.jenkins.build.jdk"))));
        toFind.add(new KeyValueData("sourceCodeUrl", (Serializable)((Object)System.getProperty("org.lsst.ccs.source.code.url"))));
        toFind.add(new KeyValueData("sourceCodeRevision", (Serializable)((Object)System.getProperty("org.lsst.ccs.source.code.revision"))));
        this.testEncodedListsNew(obj, toFind);
        DistributionInfo res = (DistributionInfo)((KeyValueData)e.getObject()).getValue();
        Assert.assertTrue((boolean)res.equals(distInfo));
    }

    @Test
    public void testRuntimeInfoEncoding() throws Exception {
        RuntimeInfo runInfo = new RuntimeInfo();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)runInfo), null);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("nThreads", (Serializable)Integer.valueOf(runInfo.getNThreads())));
        toFind.add(new KeyValueData("maxMemory", (Serializable)Long.valueOf(runInfo.getMaxMemory())));
        toFind.add(new KeyValueData("totalMemory", (Serializable)Long.valueOf(runInfo.getTotalMemory())));
        toFind.add(new KeyValueData("freeMemory", (Serializable)Long.valueOf(runInfo.getFreeMemory())));
        toFind.add(new KeyValueData("processCpuLoad", (Serializable)Double.valueOf(runInfo.getProcessCpuLoad())));
        toFind.add(new KeyValueData("systemCpuLoad", (Serializable)Double.valueOf(runInfo.getSystemCpuLoad())));
        toFind.add(new KeyValueData("uptime", (Serializable)Integer.valueOf(runInfo.getUptime())));
        this.testEncodedListsNew(obj, toFind);
        RuntimeInfo res = (RuntimeInfo)((KeyValueData)e.getObject()).getValue();
        Assert.assertTrue((boolean)res.equals(runInfo));
    }

    @Test
    public void testStateBundleEncoding() throws Exception {
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setState(new Enum[]{PhaseState.CLOSING});
        sb.setState(new Enum[]{PhaseState.INITIALIZING});
        sb.setState(new Enum[]{OperationalState.ENGINEERING_FAULT});
        sb.setState(new Enum[]{AlertState.NOMINAL});
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)sb), null);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("allStates/PhaseState", (Serializable)((Object)"INITIALIZING")));
        toFind.add(new KeyValueData("allStates/OperationalState", (Serializable)((Object)"ENGINEERING_FAULT")));
        toFind.add(new KeyValueData("allStates/AlertState", (Serializable)((Object)"NOMINAL")));
        toFind.add(new KeyValueData("lastModified/seconds", (Serializable)Long.valueOf(sb.getLastModified().getEpochSecond())));
        toFind.add(new KeyValueData("lastModified/nanos", (Serializable)Integer.valueOf(sb.getLastModified().getNano())));
        this.testEncodedListsNew(obj, toFind);
        StateBundle res = (StateBundle)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res, (Object)sb);
    }

    @Test
    public void testAgentInfoEncoding() throws Exception {
        AgentInfo ai = new AgentInfo("a1", AgentInfo.AgentType.LISTENER);
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)ai), null);
        KeyValueDataList obj = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("name", (Serializable)((Object)"a1")));
        toFind.add(new KeyValueData("type", (Serializable)((Object)"LISTENER")));
        this.testEncodedListsNew(obj, toFind);
        AgentInfo res = (AgentInfo)((KeyValueData)e.getObject()).getValue();
        Assert.assertEquals((Object)res, (Object)ai);
    }

    @Test
    public void testHeartBeatEncoding() throws Exception {
        StatusHeartBeat hb = new StatusHeartBeat(2, null);
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setState(new Enum[]{PhaseState.INITIALIZING});
        sb.setState(new Enum[]{OperationalState.ENGINEERING_FAULT});
        sb.setState(new Enum[]{AlertState.NOMINAL});
        Assert.assertTrue((hb.getEncodedData() == null ? 1 : 0) != 0);
    }

    @Test
    public void testDataList() throws Exception {
        KeyValueDataList dl1 = new KeyValueDataList();
        Complex2 complex2 = new Complex2(new BigDecimal("33.33"), 945);
        dl1.addData("cmplx2", (Serializable)complex2);
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        Complex1 complex1 = new Complex1(child, 966);
        dl1.addData("cmplx1", (Serializable)complex1);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("one", 1);
        map.put("another", new SimpleChild("child", 45, 2345.0));
        map.put("last", "done");
        dl1.addData("map", (Serializable)map);
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("cmplx2/value", (Serializable)new BigDecimal("33.33")));
        toFind.add(new KeyValueData("cmplx2/id", (Serializable)Integer.valueOf(945)));
        toFind.add(new KeyValueData("cmplx1/son/name", (Serializable)((Object)"aSin")));
        toFind.add(new KeyValueData("cmplx1/son/value", (Serializable)Integer.valueOf(666)));
        toFind.add(new KeyValueData("cmplx1/son/valDouble", (Serializable)Double.valueOf(0.7)));
        toFind.add(new KeyValueData("cmplx1/id", (Serializable)Integer.valueOf(966)));
        toFind.add(new KeyValueData("map/one", (Serializable)Integer.valueOf(1)));
        toFind.add(new KeyValueData("map/another/name", (Serializable)((Object)"child")));
        toFind.add(new KeyValueData("map/another/value", (Serializable)Integer.valueOf(45)));
        toFind.add(new KeyValueData("map/another/valDouble", (Serializable)Double.valueOf(2345.0)));
        toFind.add(new KeyValueData("map/last", (Serializable)((Object)"done")));
        StatusSubsystemData e = new StatusSubsystemData((KeyValueData)dl1, null);
        KeyValueDataList obj = e.getEncodedData();
        this.testEncodedListsNew(obj, toFind);
        KeyValueDataList res = (KeyValueDataList)e.getObject();
        Assert.assertEquals((Object)res, (Object)dl1);
    }

    @Test
    public void testDataTypeEncoding() throws Exception {
        KeyValueDataList dl1 = new KeyValueDataList();
        dl1.addData("test_data", (Serializable)((Object)"test_data"));
        dl1.addData("test_data1", (Serializable)((Object)"test_data1"));
        dl1.addData("test_plot", (Serializable)((Object)"test_plot"), KeyValueData.KeyValueDataType.KeyValuePlotData);
        dl1.addData("test_plot1", (Serializable)((Object)"test_plot1"), KeyValueData.KeyValueDataType.KeyValuePlotData);
        StatusSubsystemData e = new StatusSubsystemData((KeyValueData)dl1, null);
        KeyValueDataList obj = e.getEncodedData();
        for (KeyValueData d : obj) {
            if (d.getKey().startsWith("test_data")) {
                Assert.assertTrue((d.getType() == KeyValueData.KeyValueDataType.KeyValueTrendingData ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((d.getType() == KeyValueData.KeyValueDataType.KeyValuePlotData ? 1 : 0) != 0);
        }
    }

    private void testEncodedListsNew(KeyValueDataList list, List<KeyValueData> toFind) {
        ArrayList<KeyValueData> l = new ArrayList<KeyValueData>();
        for (KeyValueData d : list) {
            l.add(d);
        }
        this.testEncodedListsNew(l, toFind);
    }

    private void testEncodedListsNew(List<KeyValueData> list, List<KeyValueData> toFind) {
        Assert.assertEquals((long)toFind.size(), (long)list.size());
        for (KeyValueData data : list) {
            KeyValueData found = null;
            String key = data.getKey();
            for (KeyValueData orig : toFind) {
                if (!orig.getKey().equals(key)) continue;
                Assert.assertEquals((Object)orig.getValue(), (Object)data.getValue());
                found = orig;
                break;
            }
            toFind.remove(found);
        }
        if (!toFind.isEmpty()) {
            for (KeyValueData d : toFind) {
                System.out.println("Item not found " + d);
            }
        }
        Assert.assertTrue((boolean)toFind.isEmpty());
    }

    @Test
    public void testSkipAllClassEncoding() throws Exception {
        SkipAllClass c = new SkipAllClass();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)c), null);
        KeyValueDataList encodedResult = e.getEncodedData();
        Assert.assertEquals((long)encodedResult.getListOfKeyValueData().size(), (long)0L);
    }

    @Test
    public void testSkipFieldEncoding() throws Exception {
        SkipSomeFields c = new SkipSomeFields();
        StatusSubsystemData e = new StatusSubsystemData(new KeyValueData("", (Serializable)c), null);
        KeyValueDataList encodedResult = e.getEncodedData();
        ArrayList<KeyValueData> toFind = new ArrayList<KeyValueData>();
        toFind.add(new KeyValueData("data1", (Serializable)Integer.valueOf(1)));
        toFind.add(new KeyValueData("data3", (Serializable)Integer.valueOf(3)));
        this.testEncodedListsNew(encodedResult, toFind);
    }

    private class SkipSomeFields
    implements Serializable {
        private final int data1 = 1;
        @SkipEncoding
        private final double data2 = 3.4;
        private final int data3 = 3;
        @SkipEncoding
        private final SkipAllClass c = new SkipAllClass();

        private SkipSomeFields() {
        }
    }

    @SkipEncoding
    private class SkipAllClass
    implements Serializable {
        private final int data = 1;

        private SkipAllClass() {
        }
    }
}

