package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * A status message containing a ConfigurationInfo object.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class StatusConfigurationInfo extends StatusMessage<ConfigurationInfo,Object> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 345313352899991L;

    /**
     * Create a StatusConfigurationInfo message by providing the state of the agent
     * and the ConfigurationInfo object to be sent.
     * @param configurationInfo The ConfigurationInfo object to be sent.
     * @param state The state of the agent when this object was created.
     * 
     */
    public StatusConfigurationInfo(ConfigurationInfo configurationInfo, StateBundle state){
        super(configurationInfo, state);
    }
        
    /**
     * Get the ConfigurationInfo object contained in this message.
     * @return The ConfigurationInfo object embedded in the message.
     */
    public ConfigurationInfo getConfigurationInfo() {
        return getObject();
    }

    @Override
    protected KeyValueDataList encodeObject(ConfigurationInfo obj) {
        return null;
    }
    
}
