package org.lsst.ccs.bus.data;

import java.util.Map;

/**
 * An alert standing for CCS version incompatibilities detected on the buses.
 * @author LSST CCS Team
 */
public enum AgentAlerts {


    ClusterAlert("ClusterAlert","Alert raised when de serialization problems are detected on the buses");
    
    private final String id, description;

    AgentAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert(Map<String,Object> alertData) {
        return new Alert(id,description,alertData);
    }
    
}
