package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.states.StateBundle;

/**
 * Status message containing an Enum, encoded as a String..
 *
 * @author LSST CCS Team
 */

public class StatusEnum<T extends Enum<T>> extends StatusMessage<T, String> {

    public StatusEnum(T obj, StateBundle state) {
        super(obj, state);
    }

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 2449996791200957582L;

    @Override
    protected String encodeObject(T obj) {
        return obj.toString();
    }

}
