package org.lsst.ccs.bus.data;

/**
 * An alert standing for CCS version incompatibilities detected on the buses.
 * @author LSST CCS Team
 */
public class ClusterAlert extends Alert {
    
    private static final long serialVersionUID = -4381474477499864521L;
    
    private final String receiver;

    private final String sender;

    public ClusterAlert(String receiver, String sender) {
        super("CCS_CLUSTER_ALERT_"+receiver+"_"+sender, "incompatible ccs versions on the buses");
        this.receiver = receiver;
        this.sender = sender;
    }
    
    /**
     * The name of the agent that received a message which is incompatible with 
     * the local CCS version.
     * @return 
     */
    public String getReceiver() {
        return receiver;
    }

    /**
     * The name of the agent that sent a message which is incompatible with the 
     * local CCS version.
     * @return 
     */
    public String getSender() {
        return sender;
    }
    
}
