package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;

/**
 **********************************************************
 *
 *  Contains the description of a monitoring data channel
 *
 *  @author Owen Saxton
 *
 **********************************************************
 */
public class MonitorChan implements Serializable {

    private String
        name,         // Channel name
        description,  // Descriptive channel name
        format,       // Format for displaying value and limits
        units,        // Units name
        lowAlarm,     // Low limit alarm name
        highAlarm;    // High limit alarm name
    private double
        lowLimit,     // Low limit value
        lowWarning,   // Offset of low warning value from low limit
        highLimit,    // High limit value
        highWarning,  // Offset of high warning value from high limit
        value;        // Data value
    private int
        page;         // The display page number


    public MonitorChan(String name, String description, String format,
                       String units, int page,
                       double lowLimit, double lowWarning, String lowAlarm,
                       double highLimit, double highWarning, String highAlarm,
                       double value) {
        this(name, description, format, units, lowLimit, lowAlarm, highLimit, highAlarm, value);
        this.page = page;
        this.lowWarning = lowWarning;
        this.highWarning = highWarning;
    }
    
    public MonitorChan(String name, String description, String format,
                       String units, double lowLimit, String lowAlarm,
                       double highLimit, String highAlarm, double value) {
        this.name = name;
        this.description = description;
        this.format = format;
        this.units = units;
        this.lowLimit = lowLimit;
        this.lowAlarm = lowAlarm;
        this.highLimit = highLimit;
        this.highAlarm = highAlarm;
        this.value = value;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setHighAlarm(String highAlarm) {
        this.highAlarm = highAlarm;
    }

    public void setHighLimit(double highLimit) {
        this.highLimit = highLimit;
    }

    public void setHighWarning(double highWarning) {
        this.highWarning = highWarning;
    }

    public void setLowAlarm(String lowAlarm) {
        this.lowAlarm = lowAlarm;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
    }

    public void setLowWarning(double lowWarning) {
        this.lowWarning = lowWarning;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getDescription() {
        return description;
    }

    public String getFormat() {
        return format;
    }

    public String getHighAlarm() {
        return highAlarm;
    }

    public double getHighLimit() {
        return highLimit;
    }

    public double getHighWarning() {
        return highWarning;
    }

    public String getLowAlarm() {
        return lowAlarm;
    }

    public double getLowLimit() {
        return lowLimit;
    }

    public double getLowWarning() {
        return lowWarning;
    }

    public String getName() {
        return name;
    }

    public String getUnits() {
        return units;
    }

    public double getValue() {
        return value;
    }

    public int getPage() {
        return page;
    }

    private static final long serialVersionUID = 8927087946865146566L;
}
