/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.utilities.structs.ParameterPath;

public final class ConfigurationInfo
implements Serializable {
    private static final long serialVersionUID = 349664303742923784L;
    public static final int DEFAULT_VERSION = -1;
    public static final int LATEST_VERSION = -2;
    public static final int UNDEF_VERSION = -3;
    private final String descriptionName;
    private final String globalName;
    private Integer version = -3;
    private final Map<String, Boolean> hasCategoryChanged = new HashMap<String, Boolean>();
    private final Map<String, String> tags = new HashMap<String, String>();
    private final Map<String, Integer> versions = new HashMap<String, Integer>();
    private final ConfigurationState configState;
    private final List<String> recentChanges = new ArrayList<String>();
    private final List<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();
    private final long time;

    public ConfigurationInfo(ConfigurationState configState, String tagName, String globalName, Map<String, String> tags, Map<String, Integer> versions, Map<String, Boolean> hasCategoryChanged, List<ConfigurationParameterInfo> parametersView, List<String> recentChanges) {
        this.configState = configState;
        this.descriptionName = tagName;
        this.tags.putAll(tags);
        this.hasCategoryChanged.putAll(hasCategoryChanged);
        this.parametersView.addAll(parametersView);
        this.recentChanges.addAll(recentChanges);
        this.recentChanges.addAll(recentChanges);
        this.globalName = globalName;
        this.versions.putAll(versions);
        this.time = System.currentTimeMillis();
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    public long getTimestamp() {
        return this.time;
    }

    public String getConfigurationName() {
        StringBuilder sb = new StringBuilder(this.descriptionName);
        if (this.globalName != null) {
            sb.append("[").append(this.globalName);
            if (this.version != null && this.version != -3) {
                sb.append("(").append(this.version).append(")");
            }
            sb.append("]");
        }
        sb.append("[").append(this.getTaggedCategories()).append("]");
        return sb.toString();
    }

    public String getGlobalName() {
        return this.globalName;
    }

    private String getTaggedCategories() {
        String res = "";
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.tags).entrySet()) {
            boolean hasChanges = this.hasChangesForCategory(entry.getKey());
            Integer v = this.getConfigVersion(entry.getValue());
            res = res + (entry.getKey().isEmpty() ? "" : entry.getKey() + ":") + entry.getValue() + (v < 0 ? "" : "(" + v + ")") + (hasChanges ? "*" : "") + ",";
        }
        if (!res.isEmpty()) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public boolean hasChangesForCategory(String category) {
        return this.hasCategoryChanged.get(category);
    }

    public boolean hasChanges() {
        for (boolean b : this.hasCategoryChanged.values()) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public String getConfigNameForCategory(String category) {
        return this.tags.get(category);
    }

    public Integer getConfigVersion(String configName) {
        if (this.versions == null) {
            return -3;
        }
        Integer ver = this.versions.get(configName);
        return ver == null ? -3 : ver;
    }

    public boolean hasCategory(String category) {
        return this.tags.containsKey(category);
    }

    public Set<String> getCategorySet() {
        return this.tags.keySet();
    }

    public ConfigurationState getConfigurationState() {
        return this.configState;
    }

    public void updateVersions(int globalVersion, Map<String, Integer> versions) {
        this.versions.putAll(versions);
        this.version = globalVersion;
    }

    public String toString() {
        return "Configuration state : " + this.configState + ":" + this.getConfigurationName();
    }

    public List<ConfigurationParameterInfo> getAllParameterInfo() {
        return Collections.unmodifiableList(this.parametersView);
    }

    public List<ConfigurationParameterInfo> getLatestChanges() {
        return Collections.unmodifiableList(this.parametersView.stream().filter(configParmInfo -> this.recentChanges.contains(configParmInfo.getPathName())).collect(Collectors.toList()));
    }

    public Map<String, String> getCurrentValuesForCategory(String category) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getCategoryName().equals(category)).collect(Collectors.toMap(ConfigurationParameterInfo::getPathName, ConfigurationParameterInfo::getCurrentValue)));
    }

    public Map<String, String> getCurrentValuesFor(String componentName) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getComponentName().equals(componentName)).collect(Collectors.toMap(ConfigurationParameterInfo::getParameterName, ConfigurationParameterInfo::getCurrentValue)));
    }

    public String getCurrentValueForParameter(String pathName) {
        if (pathName.contains("//")) {
            System.out.println("double slash should be removed when accessing the value of a parameter by its path");
        }
        ParameterPath pp = ParameterPath.valueOf((String)pathName);
        return this.parametersView.stream().filter(parmInfo -> parmInfo.getPathName().equals(pp.toString())).map(ConfigurationParameterInfo::getCurrentValue).findFirst().get();
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByComponent(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getComponentName, Collectors.toList()));
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByCategory(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getCategoryName, Collectors.toList()));
    }
}

