package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * Base class for all status messages containing data that is private
 * to the sender Subsystem.
 * Because clients will not necessarily have the class definition for the embedded
 * object, this class relies on the encoding procedure of the embedded object.
 * 
 * @author LSST CCS Team
 */
public final class StatusSubsystemData extends StatusData {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -323533823720923L;
    
    private final String key;


    /**
     * Build a StatusMessage from the provided Object.
     *
     * @param kvData The KeyValue object to be sent over the buses.
     * @param state The State of the Agent at the time the object is created.
     */
    public StatusSubsystemData(KeyValueData kvData, StateBundle state) {
        super(kvData, state);
        key = kvData.getKey();
    }
    
    /**
     * Get the Key of the embedded object.
     * If the embedded object is a KeyValueData, then the KeyValueData's key
     * is returned, otherwise the canonical name of the class of the embedded
     * object.
     * 
     * @return The key of the embedded object.
     */    
    public String getDataKey() {
        return key;        
    }

    /**
     * Get the embedded subsystem data.
     * 
     * @return The subsystem data embedded in this message.
     * @throws EmbeddedObjectDeserializationException if the embedded object
     * cannot be deserialized.
     * 
     */
    public KeyValueData getSubsystemData() {
        return (KeyValueData)getObject();
    }
    
}
