/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationParameterInfo
implements Serializable {
    private static final long serialVersionUID = 85957367834684384L;
    private final String pathName;
    private final String categoryName;
    private final String configuredValue;
    private final String currentValue;
    private final boolean dirty;
    private final Boolean isFinal;
    private final String componentName;
    private final String parameterName;
    private final String typeName;
    private final transient String description;

    public ConfigurationParameterInfo(String pathName, String categoryName, String type, boolean isFinal, String configuredValue, String currentValue, boolean dirty, String description) {
        this.pathName = pathName;
        this.categoryName = categoryName;
        this.configuredValue = configuredValue;
        this.currentValue = currentValue;
        this.dirty = dirty;
        ParameterPath pp = ParameterPath.valueOf((String)pathName);
        this.componentName = pp.getComponentName();
        this.parameterName = pp.getParameterName();
        this.typeName = type;
        this.description = description;
        this.isFinal = isFinal;
    }

    @Deprecated
    public ConfigurationParameterInfo(String pathName, String categoryName, String type, String configuredValue, String currentValue, boolean dirty, String description) {
        this.pathName = pathName;
        this.categoryName = categoryName;
        this.configuredValue = configuredValue;
        this.currentValue = currentValue;
        this.dirty = dirty;
        this.componentName = pathName.split("/")[0];
        this.parameterName = pathName.split("/")[2];
        this.typeName = type;
        this.description = description;
        this.isFinal = null;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getConfiguredValue() {
        return this.configuredValue;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.typeName;
    }

    public boolean isFinal() {
        if (this.isFinal == null) {
            Logger.getLogger((String)"org.lsst.ccs.bus.data").warn((Object)"this version of ConfigurationParameterInfo does not contain the isFinal information. returning false");
            return false;
        }
        return this.isFinal;
    }

    public String toString() {
        return "ConfigurationParameterInfo{pathName=" + this.pathName + ", categoryName=" + this.categoryName + ", configuredValue=" + this.configuredValue + ", currentValue=" + this.currentValue + ", isDirty=" + this.dirty + '}';
    }
}

