/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder;

public class TestStateBundle {
    private static final String CLASS_ROOT = "org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder$";

    @Test
    public void testBundleCreation() {
        StateBundle bundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING});
        Assert.assertTrue((boolean)bundle.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)bundle.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((!bundle.isInState((Enum)CommandState.READY) ? 1 : 0) != 0);
    }

    @Test
    public void testBundleMerge() {
        StateBundle bundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING});
        StateBundle bundle2 = new StateBundle(new Enum[]{OperationalState.NORMAL, CommandState.READY});
        StateBundle merge = bundle.mergeState(bundle2);
        merge.setState((Enum)AlertState.NOMINAL);
        Assert.assertTrue((boolean)bundle.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)bundle.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((!bundle.isInState((Enum)CommandState.READY) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)merge.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)merge.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((boolean)merge.isInState((Enum)CommandState.READY));
        Assert.assertTrue((boolean)merge.isInState((Enum)AlertState.NOMINAL));
    }

    @Test
    public void testBundleDiff() throws Exception {
        StateBundle oldbundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING, AlertState.WARNING});
        StateBundle newbundle = new StateBundle(new Enum[]{OperationalState.NORMAL, CommandState.READY, AlertState.WARNING});
        StateBundle oldBundleAfter = this.deserialize(this.serialize(oldbundle));
        StateBundle newBundleAfter = this.deserialize(this.serialize(newbundle));
        StateBundle diffState = newBundleAfter.diffState(oldBundleAfter);
        Assert.assertEquals((Object)OperationalState.NORMAL, (Object)diffState.getState(OperationalState.class));
        Assert.assertEquals((Object)CommandState.READY, (Object)diffState.getState(CommandState.class));
        Assert.assertNull((Object)diffState.getState(AlertState.class));
        Assert.assertNull((Object)diffState.getState(PhaseState.class));
    }

    @Test
    public void testStateBundleCustomSerialization() throws Exception {
        StateBundle before = new StateBundle(new Enum[]{OperationalState.NORMAL, PhaseState.CLOSING});
        byte[] ser = this.serialize(before);
        StateBundle after = this.deserialize(ser);
        Assert.assertTrue((boolean)after.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)after.isInState((Enum)PhaseState.CLOSING));
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testSubsystemSpecifcStateBundleCustomSerialization() throws Exception {
        StateBundle before = new StateBundle(new Enum[]{OperationalState.NORMAL, PhaseState.INITIALIZING, CommandState.READY});
        SubsystemSpecificStateAdder.addFilterState(before, true);
        SubsystemSpecificStateAdder.addShutterState(before, false);
        byte[] ser = this.serialize(before);
        StateBundle after = this.deserialize(ser);
        Assert.assertTrue((boolean)after.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)after.isInState((Enum)PhaseState.INITIALIZING));
        Assert.assertTrue((boolean)after.isInState((Enum)CommandState.READY));
        Assert.assertEquals((long)2L, (long)after.getInternalStates().size());
        Assert.assertEquals((Object)"LOADING", after.getInternalStates().get("org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder$FilterState"));
        Assert.assertEquals((Object)"CLOSED", after.getInternalStates().get("org.lsst.ccs.bus.states.other.SubsystemSpecificStateAdder$ShutterState"));
        ser = this.serialize(after);
        StateBundle after2 = this.deserialize(ser);
        Assert.assertEquals((Object)after, (Object)after2);
    }

    private byte[] serialize(StateBundle bundle) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(bundle);
        byte[] res = bos.toByteArray();
        bos.close();
        oos.close();
        return res;
    }

    private StateBundle deserialize(byte[] ba) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(ba));
        StateBundle sb = (StateBundle)ois.readObject();
        ois.close();
        return sb;
    }
}

