package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.apache.log4j.Logger;

/**
 * Represents the state of a given parameter.
 * @author The LSST CCS Team
 */
public class ConfigurationParameterInfo implements Serializable {
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 85957367834684384L;
    
    private final String pathName;
    private final String categoryName;
    private final String configuredValue;
    private final String currentValue;
    private final boolean dirty;
    private final Boolean isFinal;
    private final String componentName;
    private final String parameterName;
    private final String typeName;
    private final transient String description;
    
    public ConfigurationParameterInfo(String pathName, String categoryName, String type, boolean isFinal, String configuredValue, String currentValue, boolean dirty, String description){
        this.pathName= pathName;
        this.categoryName = categoryName;
        this.configuredValue = configuredValue;
        this.currentValue = currentValue;
        this.dirty = dirty;
        this.componentName = pathName.split("/")[0];
        this.parameterName = pathName.split("/")[2];
        this.typeName = type;
        this.description = description;
        this.isFinal = isFinal;
    }
    
    @Deprecated
    public ConfigurationParameterInfo(String pathName, String categoryName, String type, String configuredValue, String currentValue, boolean dirty, String description){
        this.pathName= pathName;
        this.categoryName = categoryName;
        this.configuredValue = configuredValue;
        this.currentValue = currentValue;
        this.dirty = dirty;
        this.componentName = pathName.split("/")[0];
        this.parameterName = pathName.split("/")[2];
        this.typeName = type;
        this.description = description;
        isFinal = null;
    }

    /**
     * The Path name of the parameter.
     * e.g : "main//TickMillis"
     * @return a String representation of the path name
     */
    public String getPathName() {
        return pathName;
    }
    
    /**
     * Returns the name of the component the parameter represented by this object
     * belongs to.
     * @return the component name
     */
    public String getComponentName() {
        return componentName;
    }
    
    /**
     * Returns the name of the parameter represented by this object.
     * @return the parameter name
     */
    public String getParameterName() {
        return parameterName;
    }

    /**
     * The category the parameter belongs to.
     * @return the category the parameter represented by this object belongs to
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * The configured value for this parameter, i.e the value defined by the 
     * last configuration loading.
     * @return a String representation of the configured value.
     */
    public String getConfiguredValue() {
        return configuredValue;
    }

    /**
     * The current value for this parameter.
     * @return a String representation of the current value assigned to the parameter
     */
    public String getCurrentValue() {
        return currentValue;
    }

    /**
     * Boolean indicating if this parameter has been changed to a value and has 
     * not been saved yet.
     * @return True if the current value does not match the configured value.
     */
    public boolean isDirty() {
        return dirty;
    }
    
    /**
     * @return The parameter's short description.
     */
    public String getDescription() {
        return description;
    }
    
    /**
     * Return the type of the parameter.
     * @return 
     */
    public String getType() {
        return typeName;
    }
    
    public boolean isFinal() {
        if (isFinal == null) {
            Logger.getLogger("org.lsst.ccs.bus.data").warn(
            "this version of ConfigurationParameterInfo does not contain the isFinal information. returning false");
            return false;
        } else {
            return isFinal;
        }
    }

    @Override
    public String toString() {
        return "ConfigurationParameterInfo{" + "pathName=" + pathName + ", categoryName=" + categoryName 
                + ", configuredValue=" + configuredValue 
                + ", currentValue=" + currentValue + ", isDirty=" + dirty + '}';
    }
    
   
    
    
}
