package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Objects;

/**
 * A Class to capture the information regarding this distribution.
 *
 * @author The LSST CCS Team
 *
 */
public final class DistributionInfo implements Serializable {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 3563213329104789L;

    private final String project = System.getProperty("org.lsst.ccs.project", "");
    private final String version = System.getProperty("org.lsst.ccs.project.version", "");
    private final String buildNumber = System.getProperty("org.lsst.ccs.jenkins.build.number", "");
    private final String buildId = System.getProperty("org.lsst.ccs.jenkins.build.id", "");
    private final String buildUrl = System.getProperty("org.lsst.ccs.jenkins.build.url", "");
    private final String buildJdk = System.getProperty("org.lsst.ccs.jenkins.build.jdk", "");
    private final String sourceCodeUrl = System.getProperty("org.lsst.ccs.source.code.url", "");
    private final String sourceCodeRevision = System.getProperty("org.lsst.ccs.source.code.revision", "");

    public String getProject() {
        return project;
    }

    public String getVersion() {
        return version;
    }

    public String getBuildNumber() {
        return buildNumber;
    }

    public String getBuildId() {
        return buildId;
    }

    public String getBuildUrl() {
        return buildUrl;
    }

    public String getBuildJdk() {
        return buildJdk;
    }

    public String getSourceCodeUrl() {
        return sourceCodeUrl;
    }

    public String getSourceCodeRevision() {
        return sourceCodeRevision;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DistributionInfo other = (DistributionInfo) obj;
        if (!Objects.equals(this.project, other.project)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.buildNumber, other.buildNumber)) {
            return false;
        }
        if (!Objects.equals(this.buildId, other.buildId)) {
            return false;
        }
        if (!Objects.equals(this.buildUrl, other.buildUrl)) {
            return false;
        }
        if (!Objects.equals(this.buildJdk, other.buildJdk)) {
            return false;
        }
        if (!Objects.equals(this.sourceCodeUrl, other.sourceCodeUrl)) {
            return false;
        }
        return Objects.equals(this.sourceCodeRevision, other.sourceCodeRevision);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tProject        : ").append(project).append("\n");
        sb.append("\tProject Version: ").append(version).append("\n");
        sb.append("\tBuild Number   : ").append(buildNumber).append("\n");
        sb.append("\tBuild Id       : ").append(buildId).append("\n");
        sb.append("\tBuild Url      : ").append(buildUrl).append("\n");
        sb.append("\tBuild Jdk      : ").append(buildJdk).append("\n");
        sb.append("\tSource Code Rev: ").append(sourceCodeRevision).append("\n");
        sb.append("\tSource Code Url: ").append(sourceCodeUrl).append("\n");
        return sb.toString();        
    }
    
}
