package org.lsst.ccs.bus.data;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

/**
 * A Class to capture the Health of the running process.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class RuntimeInfo implements Serializable {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -72154637904826248L;
    
    public final int nThreads;
    public final long maxMemory = Runtime.getRuntime().maxMemory();
    public final long totalMemory, freeMemory;
    public final double processCpuLoad, systemCpuLoad;
    public transient static OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    public transient static Runtime runtime = Runtime.getRuntime();
    public final int uptime;

    public RuntimeInfo() {
        this(0);
    }
    
    public RuntimeInfo(int uptime) {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();        
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
        this.uptime = uptime;
    }
    

    public int getNThreads() {
        return nThreads;
    }

    public long getMaxMemory() {
        return maxMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public double getProcessCpuLoad() {
        return processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return systemCpuLoad;
    }
    
    /**
     * Get the Agent's uptime in milliseconds.
     * This is the amount of time since the Agent was created.
     * @return The subsystem uptime in milliseconds.
     */
    public int getUptime() {
        return uptime;
    }

}
