package org.lsst.ccs.bus.states;

/**
 * The Configuration state of a subsystem reflects the state of its set of
 * configurable parameters.
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * @author The LSST CCS Team
 */
public enum ConfigurationState implements AgentState {
    
    /**
     * The current configuration state is fully backed up by the configuration system.
     */
    CONFIGURED,
    
    /**
     * The current configuration state has been modified and not saved yet.
     */
    DIRTY,
    
    /**
     * The subsystem has been submitted one or more potential changes that
     * have not been applied yet.
     */
    CONFIGURING,
    
    /**
     * The configuration system is unreachable.
     */
    UNCONFIGURED;
}
