/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.utilities.time.CCSInstantFactory;

public class StateBundle
implements Serializable,
Cloneable {
    private Map<String, Enum> allStates = new ConcurrentHashMap<String, Enum>();
    private Instant lastModified = CCSInstantFactory.now();

    public StateBundle(Enum ... states) {
        for (Enum state : states) {
            this.innerSetState(state);
        }
        this.updateLastModified();
    }

    private StateBundle(StateBundle b) {
        this.allStates.putAll(b.allStates);
        this.lastModified = b.lastModified;
    }

    public StateBundle mergeState(StateBundle newState) {
        StateBundle clone = this.clone();
        clone.allStates.putAll(newState.allStates);
        clone.updateLastModified();
        return clone;
    }

    public StateBundle diffState(StateBundle oldState) {
        StateBundle diff = new StateBundle(new Enum[0]);
        for (Enum e : this.allStates.values()) {
            if (oldState.isInState(e)) continue;
            diff.innerSetState(e);
        }
        diff.updateLastModified();
        return diff;
    }

    public final void setState(Enum state) {
        this.innerSetState(state);
        this.updateLastModified();
    }

    public final void setState(Enum ... states) {
        for (Enum state : states) {
            this.innerSetState(state);
        }
        this.updateLastModified();
    }

    private void innerSetState(Enum state) {
        this.allStates.put(state.getClass().getSimpleName(), state);
    }

    public final <T extends Enum<T>> Enum getState(Class<T> enumClass) {
        return this.allStates.get(enumClass.getSimpleName());
    }

    public <T extends Enum<T>> boolean isInState(T state) {
        Enum e = this.getState(state.getClass());
        return e == null ? false : e.equals(state);
    }

    public boolean isInState(StateBundle stateBundle) {
        for (Enum e : stateBundle.allStates.values()) {
            if (this.isInState(e)) continue;
            return false;
        }
        return true;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateBundle)) {
            return false;
        }
        StateBundle state = (StateBundle)o;
        if (this.allStates.size() != state.allStates.size()) {
            return false;
        }
        for (String c : this.allStates.keySet()) {
            if (state.isInState(this.allStates.get(c))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Enum e : this.allStates.values()) {
            result = 31 * result + e.hashCode();
        }
        return result;
    }

    public StateBundle clone() {
        StateBundle b = new StateBundle(this);
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.allStates.forEach((k, v) -> sb.append((String)k).append(":").append(v).append(","));
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "Empty state";
    }

    private void updateLastModified() {
        this.lastModified = CCSInstantFactory.now();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.allStates.size());
        for (Enum e : this.allStates.values()) {
            out.writeObject(e.getClass().getName());
            out.writeObject(e.toString());
        }
        out.writeObject(this.getLastModified());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        this.allStates = new ConcurrentHashMap<String, Enum>(n);
        for (int i = 0; i < n; ++i) {
            String className = (String)in.readObject();
            String value = (String)in.readObject();
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getDeclaredMethod("valueOf", String.class);
                Enum e = (Enum)m.invoke(null, value);
                this.allStates.put(c.getSimpleName(), e);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.lastModified = (Instant)in.readObject();
    }
}

