package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.StateBundle;


/**
 * Base class for all status messages containing an RaisedAlert.
 * A RaisedAlert object is embedded within this StatusRaisedAlert.
 * StatusRaisedAlert provides no encoding as the RaisedAlert object already encodes
 * the original Alerts that triggered the publication.
 * 
 * @author LSST CCS Team
 * 
 */
public final class StatusRaisedAlert extends StatusAlert<Alert, Alert> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -99432048079237342L;
    
   
    public StatusRaisedAlert(Alert alert, StateBundle state) {
        super(alert, state, null);
    }

     /**
     * Build a StatusAlert from the provided RaisedAlert.
     *
     * @param alert The RaisedAlert object that caused the publication of this StatusAlert.
     * @param state The State of the Agent at the time the object is created.
     * @param raisedAlertSummary the summary of all uncleared alerts at the time
     * the object is created.
     */
    public StatusRaisedAlert(Alert alert, StateBundle state, RaisedAlertSummary raisedAlertSummary) {
        super(alert, state, raisedAlertSummary);
    }

    /**
     * Get the RaisedAlert contained in this message.
     * @return The RaisedAlert.
     */
    public Alert getRaisedAlert() {
        return getObject();
    }
    
    @Override
    protected Alert encodeObject(Alert obj) {
        return new Alert(obj.getAlertId(),obj.getDescription());
    }

}
