package org.lsst.ccs.bus.messages;


/**
 * Command Ack.
 * Returned when a CommandRequest has been accepted and the recipient will carry
 * out the corresponding execution.
 * 
 * @author LSST CCS Team
 */
public final class CommandAck extends CommandReply<String> {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 95452495415777347L;

    //REVIEW: should we consider returning an estimate of how long the command
    //execution will take?
    /**
     * CommandAcks are constructed from the corresponding CommandRequest. 
     * @param command The CommandRequest for which this CommandAck is being sent.
     */
    public CommandAck(CommandRequest command) {
        super(command, "OK");
    }

    @Override
    public String toString() {
        String origin = getOriginAgentInfo() != null ? getOriginAgentInfo().getName() : "notSet";
        return getClass().getName() + "(from " + origin + ")";
    }

}
