package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.lsst.ccs.bus.states.AlertState;

/**
 * This class represents an instance when an Alert was raised.
 * It contains the CCS timestamp of when the Alert was raised and the
 * AlertState with which it was raised.
 * 
 * This class is immutable.
 * 
 * @author The LSST CCS Team
 * 
 */
public final class RaisedAlertInstance implements Serializable {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 312950371630569273L;
    
    private final AlertState severity;
    private final long timestamp;
    private final String description;
    
    RaisedAlertInstance(AlertState severity, long timestamp, String description) {
        this.severity = severity;
        this.timestamp = timestamp;
        this.description = description;
    }

    /**
     * The CCS timestamp of when the RaisedAlertInstance was raised.
     *
     * @return The CCS timestamp.
     */
    public long getTimestamp() {
        return timestamp;
    }

    /**
     * The AlertState at which the RaisedAlertInstance was raised.
     *
     * @return The AlertState of the Alert.
     */
    public AlertState getAlertState() {
        return severity;
    }
    
    /**
     * The description of the RaisedAlert.
     * 
     * @return The description of this instance of the RaisedAlert.
     */
    public String getDescription() {
        return description;
    }
    
}
