/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;

public class TestAlerts {
    public static Alert alert;
    public static Alert alert2;
    public static Alert customAlert;
    public RaisedAlertHistory raisedAlert;
    public RaisedAlertHistory raisedAlert2;
    public RaisedAlertHistory raisedCustomAlert;
    public RaisedAlertHistory raisedCustomAlert2;

    @BeforeClass
    public static void initializeTests() {
        alert = new Alert("001", "Some alert");
        customAlert = new CustomAlert();
        alert2 = new Alert("002", "Some alert");
    }

    @Before
    public void initializeAlertHistory() {
        this.raisedAlert = new RaisedAlertHistory();
        this.raisedAlert2 = new RaisedAlertHistory();
        this.raisedCustomAlert = new RaisedAlertHistory();
        this.raisedCustomAlert2 = new RaisedAlertHistory();
        this.raisedAlert.addAlertInstance(AlertState.NOMINAL, alert);
        this.raisedAlert2.addAlertInstance(AlertState.NOMINAL, alert2);
        this.raisedCustomAlert.addAlertInstance(AlertState.NOMINAL, customAlert);
        this.raisedCustomAlert2.addAlertInstance(AlertState.NOMINAL, customAlert);
    }

    @Test
    public void testAlertsEquals() {
        Assert.assertTrue((boolean)alert.equals((Object)customAlert));
        Assert.assertTrue((!alert2.equals((Object)customAlert) ? 1 : 0) != 0);
        Assert.assertTrue((!alert2.equals((Object)alert) ? 1 : 0) != 0);
    }

    @Test
    public void testBasicContentOfRaisedAlerts() throws IOException {
        Assert.assertTrue((boolean)this.raisedAlert.getLatestAlert().equals((Object)alert));
        Assert.assertTrue((boolean)this.raisedAlert.getLatestAlert().equals((Object)customAlert));
        Assert.assertTrue((boolean)this.raisedCustomAlert.getLatestAlert().equals((Object)alert));
        Assert.assertTrue((boolean)this.raisedCustomAlert.getLatestAlert().equals((Object)customAlert));
    }

    @Test
    public void testFillingRaisedAlerts() {
        Assert.assertTrue((this.raisedAlert.getHighestAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        this.raisedAlert.addAlertInstance(AlertState.WARNING, alert);
        this.raisedAlert.addAlertInstance(AlertState.WARNING, alert);
        this.raisedAlert.addAlertInstance(AlertState.WARNING, alert);
        Assert.assertTrue((this.raisedAlert.getNumberOfInstances() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((this.raisedAlert.getHighestAlertState() == AlertState.WARNING ? 1 : 0) != 0);
        this.raisedAlert.addAlertInstance(AlertState.ALARM, alert);
        this.raisedAlert.addAlertInstance(AlertState.WARNING, alert);
        this.raisedAlert.addAlertInstance(AlertState.WARNING, alert);
        long last = System.currentTimeMillis();
        this.raisedAlert.addAlertInstance(AlertState.WARNING, alert, last);
        Assert.assertTrue((this.raisedAlert.getHighestAlertState() == AlertState.ALARM ? 1 : 0) != 0);
        Assert.assertTrue((this.raisedAlert.getNumberOfInstances() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((this.raisedAlert.getLatestAlertTimestamp() == last ? 1 : 0) != 0);
    }

    static class CustomAlert
    extends Alert {
        CustomAlert() {
            super("001", "Some other alert");
        }
    }
}

