package org.lsst.ccs.bus.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * Package protected class with Serialization utility methods.
 * 
 * @author The LSST CCS Team 
 * @param <T> 
 */
public class SerializationUtils <T extends Serializable> implements Serializable {
    
    /**
     * Serialize the provided object.
     *
     * @param obj The Serializable object to be serialized.
     * @return The byte array serialized representation of the provided object.
     * @throws IOException if the object cannot be serialized.
     *
     */
    public byte[] serialize(T obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        return bos.toByteArray();
    }

    /**
     * De-serialize the byte array serialized version of an object into the Object itself.
     *
     * @param bytes the byte array serialized version of the object.
     * @return The de-serialized object
     * @throws Exception if the object cannot be de-serialized.
     */
    public T deserialize(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            return (T) ois.readObject();
        } catch (ClassNotFoundException x) {
            throw new IOException("Class not found while deserializing embedded object", x);
        }
    }

}
