package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;

/**
 * This Object contains the xml representation of Aida plots.
 * It is meant to be filled on a Subsystem side with generated plots and
 * sent on the Status Bus as part of a StatusData object.
 * It will be intercepted by client side codes so that the plots can be displayed.
 * 
 * @author The LSST CCS Team
 */
//TODO: This class is to be removed. KeyValueDataList is to be published instead.
@Deprecated
/**
 * USE corresponding class in org.lsst.ccs.bus.data
 */
public class AidaPlots extends KeyValueDataList {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 59667514469926247L;
    
    //Implementation Note: in principle we could add a plot using an IManagedObject
    //but we don't want to add a dependency on AIDA at this level.
    //A utility function could be provided a the subsystem level, where the
    //AIDA dependency might already be present.
    
    /**
     * Add the xml representation of an AIDA plot with a corresponding name.
     * 
     * @param name The name of the AIDA plot.
     * @param plot The xml representation of the AIDA plot.
     */
    public void addPlot(String name, String plot) {
        super.addData(name, plot, System.currentTimeMillis(), KeyValueData.KeyValueDataType.KeyValuePlotData);
    }
    
    /**
     * Add the xml representation of an AIDA plot with a corresponding name and
     * a timestamp.
     * 
     * @param name The name of the AIDA plot.
     * @param plot The xml representation of the AIDA plot.
     * @param timestamp The timestamp of the embedded plot.
     */
    public void addPlot(String name, String plot, long timestamp) {
        super.addData(name, plot, timestamp, KeyValueData.KeyValueDataType.KeyValuePlotData);
    }
}
